import React from 'react';
import { Routes, Route } from 'react-router-dom'
import { ColorModeContext, useMode } from './theme';
import { CssBaseline, ThemeProvider } from '@mui/material';
import Topbar from './scenes/dashboard/global/Topbar';
import Dashboard from './scenes/dashboard/Dashboard';
import Sidebar from './scenes/dashboard/global/Sidebar';
import Bar from './scenes/dashboard/charts/Bar';
import RealDataTable from './scenes/dashboard/real_data/RealDataTable';
import Picking from './scenes/dashboard/picking/Picking';
import Line from './scenes/dashboard/charts/Line';
import Pie from "./scenes/dashboard/charts/Pie";
import Bullet from "./scenes/dashboard/charts/Bullet";

function App() {
  const [theme, colorMode] = useMode()

  return (
    <ColorModeContext.Provider value={colorMode}>
      <ThemeProvider theme={theme}>
        <CssBaseline/>
        <div className="app">
          <Sidebar/>
          <main className='content' style={{overflowY: "scroll"}}>
            <Topbar/>
            <Routes>
              <Route path='/' element={<Dashboard/>}/>
              <Route path='/bar' element={<Bar/>}/>
              <Route path='/line' element={<Line/>}/>
              <Route path='/pie' element={<Pie/>}/>
              <Route path='/bullet' element={<Bullet/>}/>
              <Route path='/realdata' element={<RealDataTable/>}/>
              <Route path='/picking' element={<Picking/>}/>
            </Routes>
          </main>
        </div>
      </ThemeProvider>
    </ColorModeContext.Provider>
  );
}

export default App;
