/// <reference types="cypress" />
// ***********************************************
// This example commands.ts shows you how to
// create various custom commands and overwrite
// existing commands.
//
// For more comprehensive examples of custom
// commands please read more here:
// https://on.cypress.io/custom-commands
// ***********************************************
//
//
// -- This is a parent command --
// Cypress.Commands.add('login', (email, password) => { ... })
//
//
// -- This is a child command --
// Cypress.Commands.add('drag', { prevSubject: 'element'}, (subject, options) => { ... })
//
//
// -- This is a dual command --
// Cypress.Commands.add('dismiss', { prevSubject: 'optional'}, (subject, options) => { ... })
//
//
// -- This will overwrite an existing command --
// Cypress.Commands.overwrite('visit', (originalFn, url, options) => { ... })
//
// declare global {
//   namespace Cypress {
//     interface Chainable {
//       login(email: string, password: string): Chainable<void>
//       drag(subject: string, options?: Partial<TypeOptions>): Chainable<Element>
//       dismiss(subject: string, options?: Partial<TypeOptions>): Chainable<Element>
//       visit(originalFn: CommandOriginalFn, url: string, options: Partial<VisitOptions>): Chainable<Element>
//     }
//   }
// }

// import '@testing-library/cypress/add-commands'

Cypress.Commands.add('clickBtnInNav', (btnName) => {
    cy.get('nav div')
      .contains(btnName)
      .parent()
      .within(() => {
        cy.get("a")
          .should('exist')
          .click({ force: true })
          .wait(1000)
    })
})

Cypress.Commands.add('graphSize', (width, height) => {
    cy.get("div[aria-haspopup='listbox']").eq(0).click()
    cy.get("li[role='option']").eq(width - 1).click()
    cy.get("div[aria-haspopup='listbox']").eq(1).click()
    cy.get("li[role='option']").eq(height - 1).click()
})

Cypress.Commands.add('changeParameter', (paramName, button) => {
    let btn = button === "left" ? 0 : 1
    cy.contains(paramName).parent("div").within(() => {
        cy.get("button").eq(btn).click()
    })
})

Cypress.Commands.add('changeSlider', (sliderName) => {
    cy.contains(sliderName).parent("div").within(() => {
        cy.get("input").parent("span")
            .trigger("mousedown", 0, 0 )
            .trigger("mousemove", 100, 0, { force: true })
            .trigger('mouseup')
    })
})

Cypress.Commands.add('changeColor', (ind, red, green, blue) => {
    cy.get("input[type='text']").eq(ind - 1).clear().type(`rgb(${red}, ${green}, ${blue}) {enter}`)
})

Cypress.Commands.add("changeSelector", (name) => {
    cy.get("input[value='nivo']").parent("div").children("div").eq(0).click()
    cy.get("li").contains(name).click()
})