describe("Dashboard tests", () => {
    beforeEach(() => {
        cy.visit("/")
        cy.contains("No graphs added").should("exist")
    })

    it("Create BarChart", () => {
        cy.contains("Edit").should("not.exist")
        cy.get("button").contains("Add graph").should("exist").click()
        cy.contains("Select type of graph").should("exist")
        cy.contains("Bar Chart").click()
        cy.contains("Result")
        cy.graphSize(6, 3)
        cy.intercept("GET", "http://127.0.0.1:5000/real_data/prod/result").as("barChart")   
        cy.contains("Create").click()
        cy.wait("@barChart")
        cy.contains("Edit").should("exist")
    })

    it("Create BulletChart", () => {
        cy.contains("Edit").should("not.exist")
        cy.get("button").contains("Add graph").should("exist").click()
        cy.contains("Select type of graph").should("exist")
        cy.contains("Bullet Chart").click()
        cy.contains("Result")
        cy.graphSize(6, 3)
        cy.intercept("GET", "http://127.0.0.1:5000/bullet/result/").as("bulletChart")   
        cy.contains("Create").click()
        cy.wait("@bulletChart")
        cy.contains("Edit").should("exist")
    })

    it("Create PieChart", () => {
        cy.contains("Edit").should("not.exist")
        cy.get("button").contains("Add graph").should("exist").click()
        cy.contains("Select type of graph").should("exist")
        cy.contains("Pie Chart").click()
        cy.contains("Defects")
        cy.graphSize(6, 3)
        cy.intercept("GET", "http://127.0.0.1:5000/real_data/defects/count").as("pieChart")   
        cy.contains("Create").click()
        cy.wait("@pieChart")
        cy.contains("Edit").should("exist")
    })

    it("Create LineChart", () => {
        cy.contains("Edit").should("not.exist")
        cy.get("button").contains("Add graph").should("exist").click()
        cy.contains("Select type of graph").should("exist")
        cy.contains("Line Chart").click()
        cy.contains("Defects")
        cy.graphSize(6, 3)
        cy.intercept("GET", "http://127.0.0.1:5000/line/defects/").as("bulletChart")   
        cy.contains("Create").click()
        cy.wait("@bulletChart")
        cy.contains("Edit").should("exist")
    })

    it("Delete graph", () => {
        cy.contains("Edit").should("not.exist")
        cy.get("button").contains("Add graph").should("exist").click()
        cy.contains("Select type of graph").should("exist")
        cy.contains("Bar Chart").click()
        cy.contains("Result")
        cy.graphSize(6, 3)
        cy.intercept("GET", "http://127.0.0.1:5000/real_data/prod/result").as("barChart")   
        cy.contains("Create").click()
        cy.wait("@barChart")
        cy.contains("Edit").should("exist")
        cy.get("svg[data-testId='DeleteIcon']").click()  
        cy.contains("Edit").should("not.exist")
    })
})

describe("Check edit graph parameters", () => {
    beforeEach(() => {
        cy.visit("/")
        cy.contains("No graphs added").should("exist")
        cy.contains("Edit").should("not.exist")
        cy.get("button").contains("Add graph").should("exist").click()
        cy.contains("Select type of graph").should("exist")
        cy.contains("Bar Chart").click()
        cy.contains("Result")
        cy.graphSize(6, 3)
        cy.intercept("GET", "http://127.0.0.1:5000/real_data/prod/result").as("barChart")   
        cy.contains("Create").click()
        cy.wait("@barChart")
        cy.contains("Edit").should("exist")
    })

    it("Edit parametres of graph", () => {
        cy.contains("Edit").click()
        cy.changeParameter("Show Legend", "left")
        cy.changeParameter("Show Legend", "right")
        cy.changeParameter("Show name X", "left")
        cy.changeParameter("Show name X", "right")
        cy.changeParameter("Show name Y", "left")
        cy.changeParameter("Show name Y", "right")
        cy.changeParameter("Group Mode", "left")
        cy.changeParameter("Group Mode", "right")
        cy.changeParameter("Layout", "left")
        cy.changeParameter("Layout", "right")
        cy.changeParameter("Reverse", "left")
        cy.changeParameter("Reverse", "right")
        cy.changeSlider("Padding")
        cy.changeSlider("Inner Padding")
        cy.changeColor(1, 255, 0, 0)
        cy.changeSelector("dark2")
        cy.changeColor(2, 0, 255, 0)
        cy.changeParameter("Enable GridX", "left")
        cy.changeParameter("Enable GridX", "right")
        cy.changeParameter("Enable GridY", "left")
        cy.changeParameter("Enable GridY", "right")
        cy.changeParameter("Enable Axis Top", "left")
        cy.changeParameter("Enable Axis Top", "right")
        cy.changeParameter("Enable Axis Right", "left")
        cy.changeParameter("Enable Axis Right", "right")
        cy.changeParameter("Is Interactive", "left")
        cy.changeParameter("Is Interactive", "right")
        cy.changeParameter("Make bar item focusable", "left")
        cy.changeParameter("Make bar item focusable", "right")
        cy.changeParameter("Is animate", "left")
        cy.changeParameter("Is animate", "right")
        cy.changeParameter("Direction", "left")
        cy.changeParameter("Direction", "right")
    })
})

