describe("Real data table tests", () => {
    beforeEach(() => {
        cy.visit("/")
        cy.intercept("GET", "http://127.0.0.1:5000/real_data/get-all").as("realData")   
        cy.clickBtnInNav("Real data")
        cy.wait("@realData")
    })
    
    it("Check sorting in Real data table", () => {
        cy.get("div[aria-label='ID']").click()
        cy.get("div[role='columnheader']").its("length").then((length) => {
            for (let check = 0; check < 2; check++) {
                for (let i = 1; i < length; i++) {
                    cy.get("div[role='row']").eq(i).children("div").eq(0).invoke("text").then((first) => {
                        cy.get("div[role='row']").eq(i + 1).children("div").eq(0).invoke("text").then((second) => {
                            if (check === 0) {
                                expect(parseInt(first)).to.lte(parseInt(second))
                            } else {
                                if (first < second) {
                                expect(parseInt(first)).to.gte(parseInt(second))
                                }
                            }
                        })
                    })                    
                }
                cy.get("div[aria-label='ID']").click()
            }
        })
    })

    it("Check pagination in Real data table", () => {
        cy.contains("Rows per page:").parent().children("div").eq(1).as("selector").click()
        cy.get("li[role='option']").its("length").then((length) => {
            cy.get("li[role='option']").eq(0).click()
            for (let i = 0; i < length; i++) {
                cy.get("@selector").click()
                cy.get("li[role='option']").eq(i).click()
            }
        })
    })
})

describe("Picking table tests", () => {
    beforeEach(() => {
        cy.visit("/")
        cy.intercept("GET", "http://127.0.0.1:5000/picking/get-all").as("pickingData")   
        cy.clickBtnInNav("Picking")
        cy.wait("@pickingData")
    })
    
    it("Check sorting in Picking table", () => {
        cy.get("div[aria-label='ID']").click()
        cy.get("div[role='columnheader']").its("length").then((length) => {
            for (let check = 0; check < 2; check++) {
                for (let i = 1; i < length; i++) {
                    cy.get("div[role='row']").eq(i).children("div").eq(0).invoke("text").then((first) => {
                        cy.get("div[role='row']").eq(i + 1).children("div").eq(0).invoke("text").then((second) => {
                            if (check === 0) {
                                expect(parseInt(first)).to.lte(parseInt(second))
                            } else {
                                if (first < second) {
                                expect(parseInt(first)).to.gte(parseInt(second))
                                }
                            }
                        })
                    })                    
                }
                cy.get("div[aria-label='ID']").click()
            }
        })
    })

    it("Check pagination in Picking table", () => {
        cy.contains("Rows per page:").parent().children("div").eq(1).as("selector").click()
        cy.get("li[role='option']").its("length").then((length) => {
            cy.get("li[role='option']").eq(0).click()
            for (let i = 0; i < length; i++) {
                cy.get("@selector").click()
                cy.get("li[role='option']").eq(i).click()
            }
        })
    })
})