describe("Navigation tests in non-collapse mode", () => {
    beforeEach(() => {
        cy.visit("/")
    })

    it("Check navigate to Real data table", () => {
        cy.clickBtnInNav("Real data")
        cy.url().should('include', '/realdata')
    })

    it("Check navigate to Picking table", () => {
        cy.clickBtnInNav("Picking")
        cy.url().should('include', '/picking')
    })

    it("Check navigate to Dashboard", () => {
        cy.clickBtnInNav("Dashboard")
        cy.url().should('include', '/')
    })
})

describe("Navigation tests in collapse mode", () => {
    beforeEach(() => {
        cy.visit("/")
        cy.get("nav button").click()
    })

    it("Check navigate to Real data table", () => {
        cy.clickBtnInNav("Real data")
        cy.url().should('include', '/realdata')
    })

    it("Check navigate to Picking table", () => {
        cy.clickBtnInNav("Picking")
        cy.url().should('include', '/picking')
    })

    it("Check navigate to Dashboard", () => {
        cy.clickBtnInNav("Dashboard")
        cy.url().should('include', '/')
    })
})