import { defineConfig } from "cypress";

export default defineConfig({
  viewportHeight: 1080,
  viewportWidth: 1920,
  defaultCommandTimeout: 25000,
  e2e: {
    setupNodeEvents(on, config) {
      // implement node event listeners here
      on("task", {
        failed: require("cypress-failed-log/src/failed")(),
      });

      on('before:browser:launch', (browser, launchOptions) => {
        if (browser.name === 'chrome' || browser.name === 'electron') {
          launchOptions.args.push('--disable-dev-shm-usage')
        }
      
        return launchOptions
      })
    },
    baseUrl: 'http://localhost:3000/',
  },
});
