#!/bin/bash

# This tiny script prepares current shell to use "tree-sitter" command
# Also creates tree-sitter config file (if it is necessary) to dismiss warnings
#
# Author: Vojtěch Dvořák


# Check if dependencies are installed
if ! test -d ./node_modules/; then
    npm install
fi

# Check if virtual enviroment for depth_test is created
DEPTH_TEST_VENV_NAME="depth_test_venv"
if ! test -d ./depth_test_venv/; then
    python3 -m venv $DEPTH_TEST_VENV_NAME && 
    . ./$DEPTH_TEST_VENV_NAME/bin/activate &&
    python3 -m pip install -r requirements.txt &&
    deactivate
fi

# Add tree-sitter binary to path to execute it easily by ./tree-sitter
ABS_PATH=$(realpath ./node_modules/.bin)
export PATH=$ABS_PATH:$PATH

# Create tree-sitter config file (TODO: clean it?)
if ! test -f ~/.config/tree-sitter/config.json; then
    tree-sitter init-config
fi
