# tree-sitter-yara
Incremental parser for YARA language based on tree-sitter. Now it should be able to parse (it creates syntax tree if it can be created) all valid constructions and features of YARA language. 

## Usage
First execute `source ./init.sh` command to prepare repository to work with tree-sitter. Or you can do it manually by following these steps: 

- For the first time (after cloning), run `npm install` to install dependencies.

- Then, use `export PATH=$(realpath ./node_modules/.bin):$PATH` command to run tree-sitter easily by `./tree-sitter`.

- For the first time it may be fine to run `./tree-sitter init-config` to dismiss warnings of tree-sitter about missing config file.

Then you you should be able to:

- Generate parser (due to grammar in `grammar.js`): `./tree-sitter generate` OR `npm run generate`

- Parse file: `./tree-sitter parse PATH` OR `npm run parse -- PATH`

- Test current version of grammar (parser): `./tree-sitter test` OR `npm test` (OR you can use `depth_test.py` by `npm run depth_test` command)


## Testing

Use `./tree-sitter test` command to run tree sitter tests or use `npm run depth_test` to run custom test script. 

Functionality of the second option is similar to the official tree-sitter solution, but it checks also unnamed nodes (there may be possibility to test also the position of symbols/tokens, but on the other hand, the test suite for this custom test script is less extensive). 
 
Note: It requires running `. ./init.sh` first to install virtual environment with dependencies.
