/**
 * @file yaramod_config.cpp 
 * @brief Contains implementation of methods of YaraModConfig 
 * 
 * @author Vojtěch Dvořák    
 */


#include "../headers/yaramod_config.h"


void YaramodConfig::setErrorMode(ErrorMode mode) {
    err_mode_ = mode;
}


YaramodConfig::ErrorMode YaramodConfig::getErrorMode() {
    return err_mode_;
}


void YaramodConfig::setParsingMode(ParsingMode mode) {
    parsing_mode_ = mode;
}


YaramodConfig::ParsingMode YaramodConfig::getParsingMode() {
    return parsing_mode_;
}


void YaramodConfig::setBaseDir(const std::string &path) {
    base_dir_ = path;
}


const std::string &YaramodConfig::getBaseDir() {
    return base_dir_;
}


void YaramodConfig::setModuleDir(const std::string &path) {
    module_dir_ = path;
}


const std::string &YaramodConfig::getModuleDir() {
    return module_dir_;
}


void YaramodConfig::addVar(const std::string &var_name, int64_t value) {
    ext_vars_.emplace(var_name, std::make_unique<ExtVariable>(var_name, value));
}


void YaramodConfig::addVar(const std::string &var_name, const std::string &value) {
    ext_vars_.emplace(var_name, std::make_unique<ExtVariable>(var_name, value));
}


void YaramodConfig::addBoolVar(const std::string &var_name, bool value) {
    ext_vars_.emplace(var_name, std::make_unique<ExtVariable>(var_name, value));
}


void YaramodConfig::removeVar(const std::string &var_name) {
    ext_vars_.erase(var_name);
}


ExtVariable *YaramodConfig::getVar(const std::string &var_name) {
    auto result_it = ext_vars_.find(var_name);
    
    if(result_it == ext_vars_.end()) {
        return nullptr;
    }
    else {
        return result_it->second.get();
    }
}

