/**
 * @file variable.cpp
 * @brief Implementation of Variable, IntVariable, ExtVariable methods
 *
 * @author Vojtěch Dvořák 
 */


#include "headers/common.h"
#include "headers/expression.h"

#include "headers/variable.h"


Variable::Variable() {
}

Variable::Variable(const std::string &id) : id_(id) {
}



const std::string &Variable::getId() const {
    return id_;
}

void Variable::setId(std::string &&id) {
    id_ = std::move(id);
}

void Variable::setId(const std::string &id) {
    id_ = id;
}


// Internal variables

IntVariable::IntVariable() {
}

IntVariable::IntVariable(const std::string &id) : Variable(id) {
}

const std::shared_ptr<Expression> &IntVariable::getValue() const {
    return value_;    
}

void IntVariable::setValue(std::shared_ptr<Expression> &&expr) {
    value_ = expr;
} 


std::stringstream IntVariable::getTextFormatted() const {
    std::stringstream sstream;

    if(value_) {
        sstream << id_ << " = " << value_->getTextFormatted().rdbuf();
    }

    return sstream;
}


// External variables

ExtVariable::ExtVariable() {
}


ExtVariable::ExtVariable(const std::string &id, const std::string &value) : Variable(id), value_(std::make_unique<Literal>(value)) {
}

ExtVariable::ExtVariable(const std::string &id, int64_t value) : Variable(id), value_(std::make_unique<Literal>(value)) {
}

ExtVariable::ExtVariable(const std::string &id, bool value) : Variable(id), value_(std::make_unique<Literal>(value)) {
}


const std::unique_ptr<Literal> &ExtVariable::getValue() const {
    return value_;
}

void ExtVariable::setValue(std::unique_ptr<Literal> &&literal) {
    value_ = std::move(literal);
}
