/**
 * @file meta.cpp 
 * @brief Contains implementation of methods of Meta
 * 
 * @author Vojtěch Dvořák 
 */

#include "../headers/common.h"

#include "../headers/meta.h"

Meta::Meta() {
}

Meta::Meta(const std::string &id, const std::string &value) : id_(id), value_(std::make_unique<Literal>(value)) {
}

Meta::Meta(const std::string &id, int64_t value) : id_(id), value_(std::make_unique<Literal>(value)) {
}

Meta::Meta(const std::string &id, bool value) : id_(id), value_(std::make_unique<Literal>(value)) {
}


const std::string &Meta::getId() const {
    return id_;
}


const std::unique_ptr<Literal> &Meta::getValue() const {
    return value_;
}


void Meta::setId(std::string &&id) {
    id_ = std::move(id);
}


void Meta::setValue(std::unique_ptr<Literal> &&literal) {
    if(!literal->isBool() && 
        !literal->isInt() && 
        !literal->isString() &&
        !literal->isUndefined()) { ///< Undefined literal is also allowed to be more tolerant against against

        throw YaramodErrorException("Meta is able to have only int, string or bool value!");
    }

    value_ = std::move(literal);
}


std::stringstream Meta::getTextFormatted() const {
    std::stringstream sstream;

    sstream << getId() << " = " << getValue()->getTextFormatted().rdbuf();

    return sstream;
}
