/**
 * @file literal.cpp 
 * @brief Implementation class Literal methods
 *
 * @author Vojtěch Dvořák 
 */

#include "headers/common.h"

#include "headers/literal.h"
#include <limits>


Literal::Literal() {
}


const LiteralValue &Literal::getRaw() const {
    return value_;
}


bool Literal::isUndefined() const {
    return std::holds_alternative<std::monostate>(value_);
}


bool Literal::isString() const {
    return std::holds_alternative<std::string>(value_);
}


bool Literal::isInt() const {
    return std::holds_alternative<int64_t>(value_);
}


bool Literal::isFloat() const {
    return std::holds_alternative<float>(value_);
}


bool Literal::isBool() const {
    return std::holds_alternative<bool>(value_);
}


std::stringstream Literal::getTextFormatted() const {
    std::stringstream sstream;

    if(isType<std::monostate>()) {
        sstream << 0;
    }
    else if(isType<std::string>()) {
        sstream << "\"" << get<std::string>() << "\"";
    }
    else if(isType<int64_t>()) {
        sstream << get<int64_t>();
    }
    else if(isType<float>()) {
        sstream << std::setprecision(std::numeric_limits<float>::max_digits10) << get<float>();
    }
    else if(isType<bool>()) {
        sstream << std::boolalpha << get<bool>() << std::noboolalpha;
    }

    return sstream;
}
