/**
 * @file rule_element.h 
 * @brief Contains declaration of RuleElement class
 * 
 * @author Vojtěch Dvořák
 */

#pragma once

#include "types.h"
#include "common.h"
#include "yara_file_element.h"
#include <memory>



/**
 * @brief Base class for all symbols that are valid in rule context 
 */
class RuleElement : public YaraFileElement {
    public:
        /**
         * Returns global offset (offset in yara file) of rule element 
         */
        offset_t getOffset() const override;
        
        /**
         * Sets global offset of rule element
         */
        void setOffset(const offset_t &offset) override;

        /**
         * Returns local offset of rule element (can be computed as 
         * 'global offset of rule element' - 'global offset of parent rule')
         */
        offset_t getLocalOffset();
        
        /**
         * Sets local offset of rule element
         */
        void setLocalOffset(const offset_t &offset);

        /**
         * Returns Range where is RuleElement located (it is global location) 
         */
        range_t getRange() const;


        void setRange(const range_t &range);

        /**
         * Returns pointer to parent rule of rule element
         */
        Rule *getParentRule() const;
        
        /**
         * Sets parent rule of the rule element
         */
        void setParentRule(const RulePtr &parent_rule);
        void setParentRule(Rule *parent_rule);

    private:
        Rule *parent_rule_ = nullptr;

        range_t range_ = {{0, 0}, {0, 0}};
};
