/**
 * @file observing_visitor.h 
 * @brief Contains declaration of ObservingVisitor class
 *
 * @author Vojtěch Dvořák 
 */

#pragma once

#include "visitor.h"


/**
 * @brief Concrete Visitor class for observing expression tree 
 * 
 * Tree is stored in condition member of rule or in value member of internal 
 * variables - Avast specific). It is base class for user-defined observing 
 * visitors 
 */
class ObservingVisitor : public Visitor {
    public:

        // Helper methods

        /**
         * Helper function to reduce redundant code of visit<BinaryExpression> 
         * methods 
         */
        void visitBinaryOperatorDefault(BinaryExpression *e);

        void visitUnaryOperatorDefault(UnaryExpression *e);

        void visitSetDefault(SetExpression *e);

        /**
         * Executes expression traversal above any Expression subclass
         */
        void start(Expression *e); 

        //---

        virtual void visitRange(Range *r) override;
        virtual void visitEnum(Enum *e) override;
        virtual void visitParentheses(ParenthesesExpression *e) override;
        
        virtual void visitIn(InExpression *e) override;
        virtual void visitMatches(MatchesExpression *e) override;
        virtual void visitAt(AtExpression *e) override;

        // Arithmetics

        virtual void visitAdd(AddExpression *e) override;
        virtual void visitSub(SubExpression *e) override;
        virtual void visitMul(MulExpression *e) override;
        virtual void visitRemainder(RemainderExpression *e) override;
        virtual void visitDiv(DivExpression *e) override;

        // Bitwise operators

        virtual void visitLeftShift(LeftShiftExpression *e) override;
        virtual void visitRightShift(RightShiftExpression *e) override;
        virtual void visitBitwiseOr(BitwiseOrExpression *e) override;
        virtual void visitBitwiseAnd(BitwiseAndExpression *e) override;
        virtual void visitBitwiseXor(BitwiseXorExpression *e) override;

        // Relational operators 

        virtual void visitLt(LtExpression *e) override;
        virtual void visitLte(LteExpression *e) override;
        virtual void visitGt(GtExpression *e) override;
        virtual void visitGte(GteExpression *e) override;
        virtual void visitEq(EqExpression *e) override;
        virtual void visitNeq(NeqExpression *e) override;

        // String relational operators

        virtual void visitContains(ContainsExpression *e) override;
        virtual void visitIContains(IContainsExpression *e) override;
        virtual void visitStartsWith(StartsWithExpression *e) override;
        virtual void visitIStartsWith(IStartsWithExpression *e) override;
        virtual void visitEndsWith(EndsWithExpression *e) override;
        virtual void visitIEndsWith(IEndsWithExpression *e) override;
        virtual void visitIEq(IEqExpression *e) override;

        // Bool operators

        virtual void visitAnd(AndExpression *e) override;
        virtual void visitOr(OrExpression *e) override;

        // Unary operators

        virtual void visitDefined(DefinedExpression *e) override;
        virtual void visitUnaryMinus(UnaryMinusExpression *e) override;
        virtual void visitBitwiseNot(BitwiseNotExpression *e) override;
        virtual void visitNot(NotExpression *e) override;

        // Terminals

        virtual void visitLiteral(LiteralExpression *e) override;
        virtual void visitSize(SizeExpression *e) override;
        virtual void visitRegexp(RegexpExpression *e) override;
        virtual void visitString(StringExpression *e) override;
        virtual void visitStringWildcard(StringWildcardExpression *e) override;
        virtual void visitStringCount(StringCountExpression *e) override;
        
        // String properties
        
        virtual void visitStringOffset(StringOffsetExpression *e) override;
        virtual void visitStringMatchLength(StringMatchLengthExpression *e) override;

        // Symbols

        virtual void visitPlainSymbol(PlainSymbol *symbol) override;
        virtual void visitArray(ArrayExpression *e) override;
        virtual void visitStruct(StructExpression *e) override;
        virtual void visitFunctionCall(FunctionCallExpression *e) override;
        virtual void visitVariable(VariableExpression *e) override;
        virtual void visitRuleWildCard(RuleWildcardExpression *e) override;

        // Quantifiers

        virtual void visitNone(NoneExpression *e) override;
        virtual void visitAny(AnyExpression *e) override;
        virtual void visitAll(AllExpression *e) override;
        virtual void visitPercentQuantifier(PercentQuantifierExpression *e) override;
        virtual void visitThem(ThemExpression *e) override;

        // Sets

        virtual void visitStringSet(StringSetExpression *e) override;
        virtual void visitRuleSet(RuleSetExpression *e) override;
        virtual void visitExpressionSet(ExpressionSetExpression *e) override;

        // Of operator

        virtual void visitOf(OfExpression *e) override;

        // For operators

        virtual void visitFor(ForExpression *e) override;
        virtual void visitForInt(ForIntExpression *e) override;
        virtual void visitVarList(VarListExpression *e) override;
};

