/**
 * @file meta.h 
 * @brief Contains declaration of Meta class 
 * 
 * @author Vojtěch Dvořák 
 */

#pragma once

#include "literal.h"
#include "rule_element.h"


/**
 * @brief Represents meta information of rule
 */
class Meta : public RuleElement, public Printable {
    public:
        Meta();
        Meta(const std::string &id, const std::string &value);
        Meta(const std::string &id, int64_t value);
        Meta(const std::string &id, bool value);

        /**
         * Returns id of the meta
         * @return Reference to string with meta id 
         */
        const std::string &getId() const;

        /**
         * Sets the id of the meta
         */
        void setId(std::string &&id);

        /**
         * Returns literal with meta value  
         */
        const std::unique_ptr<Literal> &getValue() const;

        /**
         * Sets the literal, that represents the value of meta
         * @note For literal in YARA are valid only bool, string and int
         * literal, if other type is given, YaramodErrorException is thrown 
         */
        void setValue(std::unique_ptr<Literal> &&literal);

        std::stringstream getTextFormatted() const;

    private:
        std::string id_ = std::string({}); ///< Meta Id

        std::unique_ptr<Literal> value_; ///< Meta value

};