/**
 * @file language.h 
 * @brief Declarations of functions and constants, that are associated
 * with YARA language (table of keywords etc...)
 * 
 * @author Vojtěch Dvořák    
 */

#pragma once

#include "types.h"

#include "tree_sitter/api.h"

#include "json/json.hpp"
#include <unordered_set>
#include <unordered_map>
#include <charconv>
#include <optional>
#include <string_view>
#include <string>
#include <iostream>


extern "C" {
    /**
     * Function implemented by generated parser (in parser.c) 
     */
    TSLanguage *tree_sitter_yara();
}


/**
 * Determines whether given string_view is same as any keyword of YARA
 * @return true if given string is keyword of YARA language 
 */
bool isYaraKeyword(std::string_view str);


/**
 * Checks if given string is valid escape sequence in YARA language
 * @return true if given string is valid escape sequence 
 */
bool isValidEscapeSequence(std::string_view str);


/**
 * Provides escape of escape sequences
 * @return character described by given escape sequence 
 */
char escapeSequenceToChar(std::string_view str);


/**
 * Holds the static database of builtin symbols of the YARA language
 * (int and uint functions, filesize variable)
 * @return JSON object with context of the symbol  
 */
const json *getBuiltinSymbol(std::string_view name);
