/**
 * @file expression_types.h 
 * @brief Contains forward declaration of expression types. It
 * is used to reduce cyclic dependencies of classes that use expressions.
 * 
 * @author Vojtěch Dvořák 
 */


#pragma once

// Virtual classes

class Expression;
class BinaryExpression;
class UnaryExpression;
class SetExpression;

//---

class Range;
class Enum;

class ParenthesesExpression;

class InExpression;
class MatchesExpression;
class AtExpression;

// Arithmetics

class AddExpression;
class SubExpression;
class MulExpression;
class RemainderExpression;
class DivExpression;

// Bitwise operators

class LeftShiftExpression;
class RightShiftExpression;
class BitwiseOrExpression;
class BitwiseAndExpression;
class BitwiseXorExpression;

// Relational operators

class LtExpression;
class LteExpression;
class GtExpression;
class GteExpression;
class EqExpression;
class NeqExpression;

// String relational operators

class ContainsExpression;
class IContainsExpression;
class StartsWithExpression;
class IStartsWithExpression;
class EndsWithExpression;
class IEndsWithExpression;
class IEqExpression;

// Boolean operators

class AndExpression;
class OrExpression;

// Unary operators

class DefinedExpression;
class UnaryMinusExpression;
class BitwiseNotExpression;
class NotExpression;

// Terminals

class LiteralExpression;
class SizeExpression;
class RegexpExpression;
class StringExpression;
class StringWildcardExpression;
class StringCountExpression;

// String properties

class StringOffsetExpression;
class StringMatchLengthExpression;

// Symbols

class PlainSymbol;
class ArrayExpression;
class StructExpression;
class FunctionCallExpression;
class VariableExpression;
class RuleWildcardExpression;

// Quantifiers

class NoneExpression;
class AnyExpression;
class AllExpression;
class PercentQuantifierExpression;

// Sets

class ThemExpression;
class SetExpression;
class StringSetExpression;
class RuleSetExpression;
class ExpressionSetExpression;

// Of

class OfExpression;

// For operators

class ForExpression;
class ForIntExpression;
class VarListExpression;

