/**
 * @file common.h 
 * @brief Auxiliary functions and classes, that can be used across the 
 * project
 * 
 * @author Vojtěch Dvořák    
 */

#pragma once


#include "types.h"
#include "error.h"
#include <string>
#include <cstdio>
#include <fstream>
#include <sstream>
#include <iostream>
#include <cstdint>


//#define DEBUG ///< Comment for disable debug log (and other debug features)

#ifdef DEBUG 
    #define DEBUG_LOG(...) fprintf(stderr, __VA_ARGS__)
#else
    #define DEBUG_LOG(...)
#endif


#define TO_STR_(NUM) #NUM
#define TO_STR(NUM) TO_STR_(NUM)

/**
 * @brief Reads file given by path to and assigns its content to given string
 */
std::string readFileToString(std::string_view path);


/**
 * @brief Converts point to offset, this conversion depends on string str which
 * must be provided as the first argument of this function
 */
offset_t pointToOffset(
    std::string_view str, 
    const point_t &point, 
    const point_t &start_pt = {0, 0}, 
    const offset_t &start_offset = 0
);


/**
 * @brief Converts offset to point (string must be provided as the first argument)
 */
point_t offsetToPoint(
    std::string_view str, 
    const offset_t &offset, 
    const point_t &start_pt = {0, 0}, 
    const offset_t &start_offset = 0
);


/**
 * @brief Creates normalized form of given path and returns it as a string 
 * @note Just normalizes path, check if pat exists must be done by caller
 */
std::string normalizeFSPath(const std::string &path_str);


/**
 * @brief Base class for types, that can be serialized 
 */
class Printable {
    public:
        /**
         * Provides serialization interface for objects that are inherited to 
         * Printable
         * @return Stringstream with serialized for of Printable object
         */
        virtual std::stringstream getTextFormatted() const = 0;
};


