/**
 * @file error.cpp 
 * @brief Implementation of members of error and exception classes
 * 
 * @author Vojtěch Dvořák    
 */


#include "headers/error.h"
#include "headers/common.h"

// Exceptions

ErrorException::ErrorException(const std::string &msg) : msg_(msg) {
}


const char *ErrorException::what() const noexcept {
    return msg_.c_str();
}


size_t YaraErrorException::getLen() const noexcept {
    return len_;
}

offset_t YaraErrorException::getOffset() const noexcept {
    return offset_;
}

range_t YaraErrorException::getRange(std::string_view str) const noexcept {
    return {offsetToPoint(str, offset_), offsetToPoint(str, offset_ + len_)};
}


// Errors


Error::Error(const std::string &desc, const offset_t &offset, const size_t &len) : desc_(desc) {
    offset_ = offset;
    len_ = len;
}

const std::string &Error::getDescription() const {
    return desc_;
}

ErrorException Error::exception() const {
    return ErrorException("Error occurred!");
}


SyntaxError::~SyntaxError() {
    DEBUG_LOG("Deleting error at %d\n", getOffset());
}


SemanticError::~SemanticError() {
    DEBUG_LOG("Deleting error at %d\n", getOffset());
}


bool SemanticError::isGlobal() const {
    return is_global_;
}


SemanticError *SemanticError::setGlobal(bool new_state) {
    is_global_ = new_state;

    return this;
}
