/**
 * @file common.cpp 
 * @brief Implementation of auxiliary functions and methods, that are used across 
 * the project
 * 
 * @author Vojtěch Dvořák    
 */


#include "headers/common.h"


std::string readFileToString(std::string_view path) {
    std::ifstream file;
    std::stringstream stream;

    try {
        file.open(path.data(), std::ios_base::out);
    }
    catch(std::exception const &e) {
        throw InternalErrorException("Unable to open file!" + std::string(e.what()));
    }

    stream << file.rdbuf();

    std::string result;
    result = std::move(stream).str();

    file.close();


    return result;
}


offset_t pointToOffset(std::string_view str, const point_t &point, const point_t &start_pt, const offset_t &start_offset) {
    size_t result = start_offset;
    point_t current_point = start_pt;

    while(str[result]) {
        if(current_point.col >= point.col && current_point.row >= point.row) {
            break;
        }

        if(str[result++] == '\n') { ///< End of the line reached
            current_point.row++;
            current_point.col = 0;
        }
        else {
            current_point.col++;
        }
    }

    return result;
}


point_t offsetToPoint(std::string_view str, const offset_t &offset, const point_t &start_pt, const offset_t &start_offset) {
    size_t current_offset = start_offset;
    point_t result = start_pt;

    //DEBUG_LOG("PT TO OFFSET CALLED: %d %d %d\n", current_offset, start_pt.row, start_pt.col);

    for(; str[current_offset] && current_offset < offset; current_offset++) {

        if(str[current_offset] == '\n') { ///< End of the line reached
            result.row++;
            result.col = 0;
        }
        else {
            result.col++;
        }
    }

    return result;
}


std::string normalizeFSPath(const std::string &path_str) {
    std::filesystem::path normalized_path = std::filesystem::weakly_canonical(std::filesystem::path(path_str)); 
    return normalized_path.make_preferred().string();
}
