/**
 * @file yaramod.h 
 * @brief Include file of yaramod-v4, that contains library interface for 
 * parsing of yara rulesets
 * 
 * @author Vojtěch Dvořák
 */

/**
 * @mainpage Documentation main page
 * 
 * This library provides interface for parsing and incremental reparsing of
 * source file in YARA language.
 * 
 * The results of parsing (which includes syntax analysis as well as semantic
 * analysis) can be accessed by high level semantic interface. 
 * The main advantage over the yaramod-v3 is the possibility of incremental
 * reparsing - edits of YARA source can be reported continuously and then
 * the mentioned high level representation can be easily updated.
 * This approach is much more faster than parsing from the scratch.
 * 
 * 
 * @see What is the YARA language? https://yara.readthedocs.io/en/stable/ 
 */

#pragma once

#include "../../src/headers/yaramod.h"
#include "../../src/headers/yaramod_config.h"
#include "../../src/headers/yara_source.h"
#include "../../src/headers/yara_file.h"
#include "../../src/headers/variable.h"
#include "../../src/headers/string.h"
#include "../../src/headers/rule.h"
#include "../../src/headers/meta.h"
#include "../../src/headers/other.h"
#include "../../src/headers/module.h"
