/**
 * @file yaramod_python_visitor.cpp
 * @brief Implementation of python bindings for Visitor class and its 
 * subclasses
 * 
 * @author Vojtěch Dvořák 
 */


#include "yaramod_python_visitor.h"


namespace py = pybind11;


void bindVisitor(pybind11::module &m) {

    // Visitor base class

    py::class_<Visitor, PyVisitor>(m, "Visitor")
        .def("visit_Range", &Visitor::visitRange)
        .def("visit_Enum", &Visitor::visitEnum)
        .def("visit_Parentheses", &Visitor::visitParentheses)
        .def("visit_In", &Visitor::visitIn)
        .def("visit_Matches", &Visitor::visitMatches)
        .def("visit_At", &Visitor::visitAt)

        .def("visit_Add", &Visitor::visitAdd)
        .def("visit_Sub", &Visitor::visitSub)
        .def("visit_Mul", &Visitor::visitMul)
        .def("visit_Remainder", &Visitor::visitRemainder)
        .def("visit_Div", &Visitor::visitDiv)

        .def("visit_LeftShift", &Visitor::visitLeftShift)
        .def("visit_RightShift", &Visitor::visitRightShift)
        .def("visit_BitwiseOr", &Visitor::visitBitwiseOr)
        .def("visit_BitwiseAnd", &Visitor::visitBitwiseAnd)
        .def("visit_BitwiseXor", &Visitor::visitBitwiseXor)

        .def("visit_Lt", &Visitor::visitLt)
        .def("visit_Lte", &Visitor::visitLte)
        .def("visit_Gt", &Visitor::visitGt)
        .def("visit_Gte", &Visitor::visitGte)
        .def("visit_Eq", &Visitor::visitEq)
        .def("visit_Neq", &Visitor::visitNeq)

        .def("visit_Contains", &Visitor::visitContains)
        .def("visit_IContains", &Visitor::visitIContains)
        .def("visit_StartsWith", &Visitor::visitStartsWith)
        .def("visit_IStartsWith", &Visitor::visitIStartsWith)
        .def("visit_EndsWith", &Visitor::visitEndsWith)
        .def("visit_IEndsWith", &Visitor::visitIEndsWith)
        .def("visit_IEq", &Visitor::visitIEq)

        .def("visit_And", &Visitor::visitAnd)
        .def("visit_Or", &Visitor::visitOr)

        .def("visit_Defined", &Visitor::visitDefined)
        .def("visit_UnaryMinus", &Visitor::visitUnaryMinus)
        .def("visit_BitwiseNot", &Visitor::visitBitwiseNot)
        .def("visit_Not", &Visitor::visitNot)

        .def("visit_Literal", &Visitor::visitLiteral)
        .def("visit_Size", &Visitor::visitSize)
        .def("visit_Regexp", &Visitor::visitRegexp)
        .def("visit_String", &Visitor::visitString)
        .def("visit_StringWildcard", &Visitor::visitStringWildcard)
        .def("visit_StringCount", &Visitor::visitStringCount)
        .def("visit_StringOffset", &Visitor::visitStringOffset)
        .def("visit_StringMatchLength", &Visitor::visitStringMatchLength)

        .def("visit_PlainSymbol", &Visitor::visitPlainSymbol)
        .def("visit_Array", &Visitor::visitArray)
        .def("visit_Struct", &Visitor::visitStruct)
        .def("visit_FunctionCall", &Visitor::visitFunctionCall)
        .def("visit_Variable", &Visitor::visitVariable)
        .def("visit_RuleWildCard", &Visitor::visitRuleWildCard)

        .def("visit_None", &Visitor::visitNone)
        .def("visit_Any", &Visitor::visitAny)
        .def("visit_All", &Visitor::visitAll)
        .def("visit_PercentQuantifier", &Visitor::visitPercentQuantifier)
        .def("visit_Them", &Visitor::visitThem)

        .def("visit_StringSet", &Visitor::visitStringSet)
        .def("visit_RuleSet", &Visitor::visitRuleSet)
        .def("visit_ExpressionSet", &Visitor::visitExpressionSet)

        .def("visit_Of", &Visitor::visitOf)

        .def("visit_For", &Visitor::visitFor)
        .def("visit_ForInt", &Visitor::visitForInt)
        .def("visit_VarList", &Visitor::visitVarList);
        

    // ObservingVisitor

    py::class_<ObservingVisitor, Visitor, PyObservingVisitor>(m, "ObservingVisitor")
        .def(py::init<>())
        
        .def("start", &ObservingVisitor::start)

        .def("visit_Range", &ObservingVisitor::visitRange)
        .def("visit_Enum", &ObservingVisitor::visitEnum)
        .def("visit_Parentheses", &ObservingVisitor::visitParentheses)
        .def("visit_In", &ObservingVisitor::visitIn)
        .def("visit_Matches", &ObservingVisitor::visitMatches)
        .def("visit_At", &ObservingVisitor::visitAt)

        .def("visit_Add", &ObservingVisitor::visitAdd)
        .def("visit_Sub", &ObservingVisitor::visitSub)
        .def("visit_Mul", &ObservingVisitor::visitMul)
        .def("visit_Remainder", &ObservingVisitor::visitRemainder)
        .def("visit_Div", &ObservingVisitor::visitDiv)

        .def("visit_LeftShift", &ObservingVisitor::visitLeftShift)
        .def("visit_RightShift", &ObservingVisitor::visitRightShift)
        .def("visit_BitwiseOr", &ObservingVisitor::visitBitwiseOr)
        .def("visit_BitwiseAnd", &ObservingVisitor::visitBitwiseAnd)
        .def("visit_BitwiseXor", &ObservingVisitor::visitBitwiseXor)

        .def("visit_Lt", &ObservingVisitor::visitLt)
        .def("visit_Lte", &ObservingVisitor::visitLte)
        .def("visit_Gt", &ObservingVisitor::visitGt)
        .def("visit_Gte", &ObservingVisitor::visitGte)
        .def("visit_Eq", &ObservingVisitor::visitEq)
        .def("visit_Neq", &ObservingVisitor::visitNeq)

        .def("visit_Contains", &ObservingVisitor::visitContains)
        .def("visit_IContains", &ObservingVisitor::visitIContains)
        .def("visit_StartsWith", &ObservingVisitor::visitStartsWith)
        .def("visit_IStartsWith", &ObservingVisitor::visitIStartsWith)
        .def("visit_EndsWith", &ObservingVisitor::visitEndsWith)
        .def("visit_IEndsWith", &ObservingVisitor::visitIEndsWith)
        .def("visit_IEq", &ObservingVisitor::visitIEq)

        .def("visit_And", &ObservingVisitor::visitAnd)
        .def("visit_Or", &ObservingVisitor::visitOr)

        .def("visit_Defined", &ObservingVisitor::visitDefined)
        .def("visit_UnaryMinus", &ObservingVisitor::visitUnaryMinus)
        .def("visit_BitwiseNot", &ObservingVisitor::visitBitwiseNot)
        .def("visit_Not", &ObservingVisitor::visitNot)

        .def("visit_Literal", &ObservingVisitor::visitLiteral)
        .def("visit_Size", &ObservingVisitor::visitSize)
        .def("visit_Regexp", &ObservingVisitor::visitRegexp)
        .def("visit_String", &ObservingVisitor::visitString)
        .def("visit_StringWildcard", &ObservingVisitor::visitStringWildcard)
        .def("visit_StringCount", &ObservingVisitor::visitStringCount)
        .def("visit_StringOffset", &ObservingVisitor::visitStringOffset)
        .def("visit_StringMatchLength", &ObservingVisitor::visitStringMatchLength)

        .def("visit_PlainSymbol", &ObservingVisitor::visitPlainSymbol)
        .def("visit_Array", &ObservingVisitor::visitArray)
        .def("visit_Struct", &ObservingVisitor::visitStruct)
        .def("visit_FunctionCall", &ObservingVisitor::visitFunctionCall)
        .def("visit_Variable", &ObservingVisitor::visitVariable)
        .def("visit_RuleWildCard", &ObservingVisitor::visitRuleWildCard)

        .def("visit_None", &ObservingVisitor::visitNone)
        .def("visit_Any", &ObservingVisitor::visitAny)
        .def("visit_All", &ObservingVisitor::visitAll)
        .def("visit_PercentQuantifier", &ObservingVisitor::visitPercentQuantifier)
        .def("visit_Them", &ObservingVisitor::visitThem)

        .def("visit_StringSet", &ObservingVisitor::visitStringSet)
        .def("visit_RuleSet", &ObservingVisitor::visitRuleSet)
        .def("visit_ExpressionSet", &ObservingVisitor::visitExpressionSet)

        .def("visit_Of", &ObservingVisitor::visitOf)

        .def("visit_For", &ObservingVisitor::visitFor)
        .def("visit_ForInt", &ObservingVisitor::visitForInt)
        .def("visit_VarList", &ObservingVisitor::visitVarList);
}
