/**
 * @file yaramod_python_expressions.h
 * @brief Header file of python bindings of Expression class and its subclasses
 * 
 * @author Vojtěch Dvořák 
 */

#pragma once

#include <pybind11/pybind11.h>
#include <pybind11/stl.h>

#include "yaramod.h"

/**
 * Binds Expression class and its subclasses 
 */
void bindExpressions(pybind11::module &m);


/**
 * Python helper class for virtual members of Expression
 */
class PyExpression : public Expression {
    public:
        using Expression::Expression;


        Expression::Type getType() const override {
            PYBIND11_OVERRIDE_PURE(Expression::Type, Expression, getType);
        }


        bool isValid(std::string_view &msg) const override {
            PYBIND11_OVERRIDE_PURE(bool, Expression, isValid, msg);
        }


        bool areOperandsValid() const override {
            PYBIND11_OVERRIDE_PURE(bool, Expression, areOperandsValid);
        }


        bool isComplete() const override {
            PYBIND11_OVERRIDE_PURE(bool, Expression, isComplete);
        }


        void accept(Visitor *v) override {
            PYBIND11_OVERRIDE_PURE(void, Expression, accept, v);
        }
};


/**
 * Python helper class for virtual members of BinaryExpression
 */
class PyBinaryExpression : public BinaryExpression {
    public:
        using BinaryExpression::BinaryExpression;

        std::string opsign() const override {
            PYBIND11_OVERRIDE_PURE(std::string, BinaryExpression, opsign);
        }
};


/**
 * Python helper class for virtual members of UnaryExpression
 */
class PyUnaryExpression : public UnaryExpression {
    public:
        using UnaryExpression::UnaryExpression;

        std::string opsign() const override {
            PYBIND11_OVERRIDE_PURE(std::string, UnaryExpression, opsign);
        }
};



/*   |                                                                   |
 *   V    Helper functions for more convenient binding of subclasses     V 
 */

template <class T>
inline pybind11::class_<T> bindBinaryExpressionClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindUnaryExpressionClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindTerminalExpressionClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindSymbolClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindStringPropertyClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindPlainSymbolClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindQuantifierExpressionClass(pybind11::module &m, const std::string &py_class_name);


template <class T>
inline pybind11::class_<T> bindSetExpression(pybind11::module &m, const std::string &py_class_name);

