/**
 * @file yaramod_python.h
 * @brief Header file of python bindings
 * 
 * @author Vojtěch Dvořák 
 */

#pragma once

#include <pybind11/pybind11.h>
#include <pybind11/stl.h>
#include <pybind11/embed.h>
#include <pybind11/complex.h>
#include <memory>

/**
 * Bind enum values of yaramodv4
 */
void bindEnumClasses(pybind11::module &m);



/**
 * Creates bindings SymTab class that stores objects of type T
 */
template<class T>
void bindSymTab(pybind11::module &m, const std::string &prefix);

/**
 * Creates bindings SymTabOffset, that stores objects of type T
 */
template<class T>
void bindSymtabOffset(pybind11::module &m, const std::string &prefix);

/**
 * Creates bindings SymTabDuplId, that stores objects of type T
 */
template<class T>
void bindSymtabDuplId(pybind11::module &m, const std::string &prefix);



/**
 * Bindings for error collector, that stores errors of type E 
 */
template<class E>
void bindErrorCollector(pybind11::module &m, const std::string &prefix);

/**
 * Creates bindings for exceptions hierarchy of Yaramodv4 
 */
void bindExceptions(pybind11::module &m);

/**
 * Creates bindings for strings and its components
 */
void bindStrings(pybind11::module &m);


/**
 * Creates bindings for rule and its components
 */
void bindRules(pybind11::module &m);

/**
 * Creates binding for Import class 
 */
void bindImports(pybind11::module &m);

/**
 * Creates binding for FileInclude class 
 */
void bindErrors(pybind11::module &m);

/**
 * Creates error bindings for classes, that represent errors 
 */
void bindFileIncludes(pybind11::module &m);

/**
 * Creates bindings for commnets 
 */
void bindComments(pybind11::module &m);

/**
 * Creates bindings for YaraFile and its components
 */
void bindYaraFile(pybind11::module &m);

