# Yaramod-v4
The new version of Yaramod library for parsing Yara rule sets. The library is implemented in C++ as its previous version, but the main advantage is possibility of incremental reparsing, that is much faster than regular batch parsing.

## Structure

- `bindings` - Source files of bindings for other languages

- `doc` - Contains necessary files for generating library documentation

- `examples` - Simple demo programs, that use this library

    + `calculator.py` - Simple script, that calculates arithmetic conditions of rules

    + `unused_strings.py` - Simple script, that identifies unused strings in rules (using visitor interface)

    + `observing_visitor.cpp` - Demo focused on visitor interface of `Expression` 

    + `parsing.cpp` - Demo focused on simple parsing of YARA files

    + `reparsing.cpp` - Demo, which shows fast incremental reparsing of YARA files 

- `lib` - Contains C++ include files of this library

- `modules` - Description of YARA modules in JSON format (IMPORTANT: they were taken from [older version of yaramod](https://github.com/avast/yaramod/tree/master/modules), format of the description is completely compatible with Yaramod-v3)

- `src` - Source files of Yaramod-v4 library

- `tests` - Tests of library

- `utils` - Tools and some libraries used by Yaramod-v4

- `CMakeLists.txt` - Script for `cmake`

## Compilation
All binaries within this project can be compiled easily by running:

```
mdkir build && cd build
cmake ..
make
```



## Third party libraries and dependencies
The following libraries were created by third parties and their functionality is used in some way in this project (as a part of library, as a testing frameworks etc.):

- [Tree-sitter library](https://github.com/tree-sitter/tree-sitter) (MIT license) - cloned automatically in config time

- [GoogleTest](https://github.com/google/googletest) (BSD-3-Clause) - cloned automatically in config time, used for unit testing

- [pybind11](https://github.com/pybind/pybind11) (BSD-style license) - cloned automatically in config time, used for generating python bindings

- [pybind/cmake_example/setup.py](https://github.com/pybind/cmake_example/blob/master/setup.py) (BSD-style license) - file `bindings/python/setup.py` was taken from [example project](https://github.com/pybind/cmake_example/blob/master/setup.py) of pybind11 and it was changed to match this project, it is used for building python package (.whl file)

- [pytest](https://docs.pytest.org/en/7.2.x/index.html) (MIT license) - should be installed on machine, where we want to execute the tests of python bindings, used for testing of python bindings

- [JSON for Modern C++](https://github.com/nlohmann/json) (MIT license) - located in `utils/json`, used for parsing description of YARA modules (in json format)

- [Yaramod-v3 modules](https://github.com/avast/yaramod/tree/master/modules) (MIT license) - JSON module descriptions located in `modules` directory are taken from the older version of this library, used for getting contextual information about symbols from YARA modules


