# Inkrementální statická analýza pro jazyk YARA - Bakalářská práce


## Autor

Vojtěch Dvořák (xdvora3o)


## Datum odevzdání

10. 5. 2023


## Zdrojové soubory třetích stran obsažené v adresáři

Následující soubory a adresáře jsou zde obsažené pouze z důvodu snazší instalace programového řešení a NEJSEM jejich autorem:
- `yaramod-v4/modules/` - Specifikace modulů ve formátu JSON, Autor: Avast, Licence: MIT, Zdroj: https://github.com/avast/yaramod
- `yaramod-v4/utils/json/` - Knihovna JSON for modern C++, Autor: Niels Lohmann, Licence: MIT, Zdroj: https://github.com/nlohmann/json


## Popis struktury adresáře

- `bp-src/` - Zdrojový tvar písemné zprávy

- `yaramod-v4/` - Zdrojové soubory knihovny Yaramod-v4
  + `bin/` - Knihovna v binární podobě
  + `bindings/python/` - Zdrojové soubory rozhraní knihovny pro jazyk Python
    - `tests` - Testy rozhraní knihovny pro jazyk Python
  + `doc/` - Soubory potřebné pro generování dokumentace
    - `Doxyfile` - Konfigurační soubor pro nástroj Doxygen (byl vygenerován tímto nástrojem a patřičně upraven)
  + `examples/` - Zdrojové soubory příkladů použití knihovny
  + `lib/` - Hlavičkové soubory knihovny
  + `modules/` - Specifikace modulů ve formátu JSON (převzato z  https://github.com/avast/yaramod)
  + `src/` - Zdrojové soubory knihovny Yaramod-v4
  + `tests/` - Testy knihovny
  + `tree-sitter-yara/` - Zdrojové soubory modulu tree-sitter-yara
    - `test` - Testovací případy pro testování gramatiky
    - `depth_test.py` - Testovací skript pro testování gramatiky
    - `grammar.js` - Gramatika jazyka YARA pro knihovnu tree-sitter
    - `init.sh` - Inicializační skript pro snazší instalaci závislostí
    - `operators.js` - Rámcové řešení pro definici operátorů pro knihovnu tree-sitter
  + `utils/` - Pomocné knihovny a projekty, které knihovna využívá
    - `json/` - Knihovna JSON for modern C++ (převzato z https://github.com/nlohmann/json)
  + `CMakeLists.txt` - Kořenový skript pro program cmake (slouží pro překlad)
  + `refman.pdf` - Referenční manuál knihovny vygenerovaný nástrojem Doxygen

- `yls` - Soubory potřebné pro integraci s projektem YLS
  + `yls.patch` - Patch soubor se změnami provedenými v rámci integrace knihovny Yaramod-v4 s projektem YLS
  + `init.sh` - Inicializační skript, který stáhne potřebnou verzi YLS a provede integraci
  + `run.sh` - Skript usnadňující spouštění VSCode s YLS

- `DEMO.mp4` - Video demonstrující fungování YLS po integraci s Yaramod-v4

- `README.md` - Detailní informace o obsahu adresáře


## Instalace a překlad zdrojových souborů

DŮLEŽITÉ: Aby nebylo nutné instalovat závislosti, je na adrese:

https://vutbr-my.sharepoint.com/:f:/g/personal/xdvora3o_vutbr_cz/ErrcSLJEAvBPtfl9-K4Rq9IB6xnIh0vBtE0oWWNkj3aV1A

možné stáhnout VM s OS Ubuntu-22.04.2 (ve formátu *.ova), na kterém je programové řešení nainstalováno (včetně všech potřebných závislostí).


Následující návod je uveden pro OS Linux (konkrétně testováno na Ubuntu-22.04.2 64bit). Dále se v rámci následujících instrukcí pro překlad a instalaci předpokládá, že se uživatel nachází v adresáři, v němž je přítomen právě tento soubor `README.md`.


### Tree-sitter-yara

Požadavky:
- npm
- GLIBC 2.34+

Tabulku pro LR syntaktický analyzátor tree-sitter lze vygenerovat pomocí:
```
cd yaramod-v4/tree-sitter-yara
. ./init.sh
tree-sitter generate
```

Poté je možné gramatiku otestovat buďto standardním způsobem:
```
npm run test
```

Nebo pomocí skriptu `depth_test.py`, který byl vytvořen v rámci této práce:
```
npm run depth_test
```

Pozn.: Vygenerovanou tabulku není zapotřebí nikam přesouvat, kopírovat apod. Knihovna Yaramod-v4 si během překladu tabulku vygeneruje sama, bude-li to zapotřebí.


### Yaramod-v4

Požadavky:
- cmake 3.24+
- Překladač GCC 11.0+ nebo Clang 14.0+ (překladač musí podporovat standard C++20 a jeho GNU rozšíření)
- python3-dev (pro tvorbu rozhraní pro jazyk Python pomocí knihovny pybind11)
- +Požadavky pro tree-sitter-yara (viz výše)

Knihovnu Yaramod-v4, její testy a příklady použití je možné přeložit pomocí následující sekvence příkazů:
```
cd yaramod-v4
mkdir build && cd build
cmake ..
make
```

Pozn.: Při prvním překladu je zapotřebí mít přístup k internetu, protože cmake automaticky stáhne všechny potřebné závislosti, které nejsou součástí adresáře. Alternativně lze při spuštění programu cmake přidat parametr `-DBUILD_DOCS=ON`, jenž do výsledného `Makefile` přidá cíl pro generování dokumentace ve formátu Doxygen nebo pomocí parametru `-DCMAKE_BUILD_TYPE=Debug` přeložit knihovnu s ladícími symboly.

Vytvořený `Makefile` dále obsahuje tyto cíle:
- `unit_tests` - Spustí jednotkové testy knihovny yaramod-v4
- `yaramodv4_tests` - Spustí testy rozhraní knihovny pro jazyk Python
- `yaramodv4_wheel` - Vytvoří `*.whl` soubor pro snadnou instalaci knihovny (např. pomocí nástroje `pip`)


### YLS

Požadavky:
- `yaramodv4-*.whl` (nutné vytvořit pomocí `make yaramodv4_wheel`, viz výše)
- diff
- poetry 1.4.2+
- (případně VSCode s rozšířením avast-threatlabs-yara.vscode-yls)

Před integrací je zapotřebí vytvořit `*.whl` soubor knihovny Yaramod-v4 (viz výše). 
Samotnou integraci knihovny Yaramod-v4 s projektem YLS je možné provést pomocí přiloženého souboru `init.sh`:
```
cd yls
./init.sh
```

Následně je možné integraci vyzkoušet pomocí editoru VSCode, který bude komunikovat se serverem YLS:
```
cd yls
poetry shell
YLS_EXEUCTABLE_PATH=$(poetry run which yls) code <WORKSPACE>
```

Kde `<WORKSPACE>` je adresář, v němž chceme VSCode otevřít.


Alternativně je možné provést spuštění také pomocí přiloženého skriptu `run.sh`:
```
poetry shell -C./yls/
./run.sh <WORKSPACE>
```

Pro podporu modulů je zapotřebí dodat jejich popis v JSON (např. z `yaramod-v4/modules`) do adresáře `yls/yls/yls/modules/` a znovunačíst VSCode.
