clear all
clc

my_Dir='c:\\...\\'; % cesta k adresi
ext_img = '*.BIF6'; % ppona soubor
a = dir([my_Dir ext_img]) % naten obsahu adrese
poc_vrs = max(size(a)); % poet soubor (vrstev)

% Zadn informac o parametrech men:
sirka = input('ka zkouman oblasti v um: '); 
sirka_px = input('ka zkouman oblasti v pixelech: ');
hloubka = input('Zjitn hloubka na profilometru: ');
sklon = 45; % vzjemn natoen iontovho dla a analyztoru
CntFile=0;

for NoFile=0:poc_vrs-1 % postupn otevrn soubor a ten hlaviky
    
filename = sprintf('c:\\...\\Mg (%d).BIF6',NoFile);
fID = fopen(filename,'r', 'l');%Little-endian systems store bytes starting with the smallest address (the little end).
FStart = fread(fID,1,'int16');% Filetype header: (6 bytes, 1 WORD set to 0x0000, ASCII 'BIF6')
FFileType = fread(fID,4,'*char');
FNoIm = fread(fID,1,'int16');% Fileinfo header: (3 WORDS, number of images, image X size, image Y size (Sizes in pixels))
FXpix = fread(fID,1,'int16');% Fileinfo header: (3 WORDS, number of images, image X size, image Y size (Sizes in pixels))
FYpix = fread(fID,1,'int16');% Fileinfo header: (3 WORDS, number of images, image X size, image Y size (Sizes in pixels))
for No=1:FNoIm
%    Imageinfo header: (16 bytes, DWORD ImageIndex,  
%                        float Massinterval center mass,  float Massinterval lower mass, float massinterval upper mass)
  ImIndex = fread(fID,1,'int32');
  MIntervalCMass = fread(fID,1,'float');
  MIntervalLoMass = fread(fID,1,'float');
  MIntervalHiMass = fread(fID,1,'float');
  for i=1:FXpix
      for j=1:FYpix
       Mg(i,j,NoFile+1)=fread(fID,1,'int32'); % zpis analyzovanho objemu Mg(intenzit) do matice
      end;
  end;
end;    
fclose(fID);
CntFile=CntFile+1;
end;  

% Vpoet parametr pro vytvoen nov matice:
x = hloubka*tan((90-sklon)*pi/180);
poc_prid_pix = ceil((sirka_px/sirka)*x); % poet pidanch pixel
pomer = poc_vrs/poc_prid_pix; 

if(pomer < 1) % kompletovn vrstev pro posuv
	posun = ceil(poc_prid_pix/poc_vrs);
	komplet = 1;
else
	posun = 1;
    komplet = ceil(poc_vrs/poc_prid_pix);
end

pic_cnt = 1;
shift = 0;
Kor_mat = int32(zeros(FXpix,FYpix+poc_prid_pix,poc_vrs)); % vytvoen rozen przdn matice pro korekci posuvu

while(pic_cnt <= poc_vrs) % cyklus pro pravu jednotlivch vrstev
	
	k = komplet;
	
	while(k && (pic_cnt <= poc_vrs)) 
                               
        for r = 1:FXpix
            for s = 1:FYpix
              Kor_mat(r,s+poc_prid_pix-shift,pic_cnt) =  Kor_mat(r,s+poc_prid_pix-shift,pic_cnt) + Mg(r,s,pic_cnt); % zpis intenzit Mg na nov pozice
            end
        end
        
        % Vytvoen novho souboru (vrstvy) .BIF6:        
        filenameR = sprintf('c:\\...\\Mg (%d).BIF6',pic_cnt-1);	
        fIDR = fopen(filenameR,'w', 'l');% little-endian systems store bytes starting with the smallest address (the little end).
        fwrite(fIDR,FStart,'int16');
        fwrite(fIDR,FFileType,'*char');
        fwrite(fIDR,FNoIm,'int16');
        fwrite(fIDR,FXpix,'int16');
        fwrite(fIDR,FYpix+poc_prid_pix,'int16');
        fwrite(fIDR,ImIndex,'int32');
        fwrite(fIDR,MIntervalCMass,'float');
        fwrite(fIDR,MIntervalLoMass,'float');
        fwrite(fIDR,MIntervalHiMass,'float');
        
        for q = 1:FXpix
            for w = 1:(FYpix+poc_prid_pix)
              fwrite(fIDR,Kor_mat(q,w,pic_cnt),'int32'); % uloen upravench informac
            end
        end
        
		k = k - 1;
		pic_cnt = pic_cnt + 1;
        
    end
    shift = shift + posun; % naven shiftu pro dal skupinu vrstev
	if shift >= poc_prid_pix % kontrola hranice rozen matice
		posun = 0;
		shift=  poc_prid_pix;
    end
end



