function [ M ] = getMeasurementMatrix( Ls, ls )
%GETMEASUREMENTMATRIX Constructs the measurement matrix for linear
%projection of 3D lines in Plücker coordinates.
%   Input:
%     Ls - 6xN matrix of Plücker coordinates of 3D lines
%     ls - 3xN matrix of homogeneous coordinates of 2D lines
%   Output:
%     M - 2Nx18 measurement matrix
%

	NLINES = size(Ls, 2);

	% notation: [L1; L2; L3; L4; L5; L6] = L (3D line), [a b c] = ls (2D line)
	M = [ ...
		[ ...
			%  c      *    L1             0             -a      *   L1
			%  c      *    L2             0             -a      *   L2
			%  c      *    L3             0             -a      *   L3
			%  c      *    L4             0             -a      *   L4
			%  c      *    L5             0             -a      *   L5
			%  c      *    L6             0             -a      *   L6
			ls(3,:)' .* Ls(1,:)'   zeros(NLINES,1)   -ls(1,:)' .* Ls(1,:)' ...
			ls(3,:)' .* Ls(2,:)'   zeros(NLINES,1)   -ls(1,:)' .* Ls(2,:)' ...
			ls(3,:)' .* Ls(3,:)'   zeros(NLINES,1)   -ls(1,:)' .* Ls(3,:)' ...
			ls(3,:)' .* Ls(4,:)'   zeros(NLINES,1)   -ls(1,:)' .* Ls(4,:)' ...
			ls(3,:)' .* Ls(5,:)'   zeros(NLINES,1)   -ls(1,:)' .* Ls(5,:)' ...
			ls(3,:)' .* Ls(6,:)'   zeros(NLINES,1)   -ls(1,:)' .* Ls(6,:)' ...
		] ; [ ...
			%      0             c      *    L1         -b      *   L1
			%      0             c      *    L2         -b      *   L2
			%      0             c      *    L3         -b      *   L3
			%      0             c      *    L4         -b      *   L4
			%      0             c      *    L5         -b      *   L5
			%      0             c      *    L6         -b      *   L6
			zeros(NLINES,1)   ls(3,:)' .* Ls(1,:)'   -ls(2,:)' .* Ls(1,:)' ...
			zeros(NLINES,1)   ls(3,:)' .* Ls(2,:)'   -ls(2,:)' .* Ls(2,:)' ...
			zeros(NLINES,1)   ls(3,:)' .* Ls(3,:)'   -ls(2,:)' .* Ls(3,:)' ...
			zeros(NLINES,1)   ls(3,:)' .* Ls(4,:)'   -ls(2,:)' .* Ls(4,:)' ...
			zeros(NLINES,1)   ls(3,:)' .* Ls(5,:)'   -ls(2,:)' .* Ls(5,:)' ...
			zeros(NLINES,1)   ls(3,:)' .* Ls(6,:)'   -ls(2,:)' .* Ls(6,:)' ...
		] ...
	];
	
	return;
end

