# Malware Sonar

The tool detects malware activites from the host-based context. It uses known IoC of malware observed in the sandbox to create a model of malware behavior. The model is then used to detect malware.


## Malware Network Communication Detection

### Overview
Detect malware network communication by comparing predefined Indicators of Compromise (IoCs) from malware samples with observed Indicators of Activities (IoA) in network traffic.

### Data Collection
1. **Malware Family Reports**: Acquire multiple reports for each malware family to effectively characterize its communication.
   
    - Each report is structured as a JSON file.
    - Essential data can be retrieved from two paths within the report: 
        - `report.analysis`
        - `report.targets[].iocs`

2. **Extraction of Information**: Extract relevant data from the report to identify IoCs in network communication. When multiple targets are identified within a report, expect multiple output records even from a single input sample.

    Sample Extracted Report:
    ```json
    {
        "sample-id" : "230321-rve5psda4z",
        "md5": "6007684ce57eebe82a7f62ae8ed09293",
        "ssdeep": "12288:sA/2303rm0yOl89i7L0aa6nQexDVwjF21iRRVgfH2IUumGanJJp4/Az5S:h/2303q0hl3L5tnQexDVwsL2umGap4kS",
        "score": 10,
        "family": [
          "agenttesla"
        ],
        "iocs": {
            ...
        }
    }
    ```

3. **Representation of IoCs**: Once the malware's IoC information is extracted, it needs to be consistently represented.
    - **Fuzzy Sets**: Represent IoCs using Fuzzy sets which also allow for the incorporation of their significance or weights. https://www.nuget.org/packages/Accord.Fuzzy/
    - **Word Vectors**: Utilize word vectors to ascertain the similarity between IoCs and IoA programmatically. See https://towardsdatascience.com/using-word-vectors-to-mathematically-find-words-with-similar-meanings-fc9eadac3dbe.

By following these principles, the detection process becomes streamlined and more effective in identifying potential threats in network traffic.

