
/// <summary>
/// Represents a set of indicators associated with a particular malware.
/// </summary>
/// <param name="Family">
/// The family name of the malware. This typically refers to a broader classification of the malware based on its behavior, characteristics, or origin.
/// </param>
/// <param name="SampleId">
/// A unique identifier for the malware sample. This can be used to reference or retrieve additional details about the specific instance of malware.
/// </param>
/// <param name="Urls">
/// An array of URLs associated with the malware. These URLs may be related to malware distribution, command and control servers, or other malicious activities.
/// </param>
/// <param name="Domains">
/// An array of domain names associated with the malware. Like URLs, these domains can be involved in various malicious activities or serve as indicators of compromise.
/// </param>
/// <param name="Ips">
/// An array of IP addresses related to the malware. These IPs may be linked to servers hosting malware, control systems, or other components of a malicious network.
/// </param>
public record MalwareIndicators(string Family, string SampleId, string[] Urls, string[] Domains, string[] Ips);
