/// <summary>
/// Represents a set of indicators within a specific context, typically related to network or system activity within a defined time window.
/// </summary>
/// <param name="Start">
/// The start date and time of the observation period. This defines the beginning of the time window during which the indicators were collected.
/// </param>
/// <param name="End">
/// The end date and time of the observation period. This marks the conclusion of the time window for the collected indicators.
/// </param>
/// <param name="Host">
/// The host (such as a server, workstation, or network device) for which these indicators are relevant. This can be an IP address, a domain name, or a machine name.
/// </param>
/// <param name="Urls">
/// An array of URLs observed in the context. These URLs could be related to normal user activity, system operations, or potential security threats.
/// </param>
/// <param name="Domains">
/// An array of domain names observed in the context. These can include internal and external domains accessed or referenced by the host.
/// </param>
/// <param name="Ips">
/// An array of IP addresses relevant to the context. This can include IPs that the host has communicated with or has been targeted by.
/// </param>
public record ContextIndicators(DateTimeOffset Start, DateTimeOffset End, string Host, string[] Urls, string[] Domains, string[] Ips);
