﻿/// <summary>
/// The Ethanol.MalwareSonar.MalwareReport namespace contains classes related to malware reporting functionality.
/// </summary>
namespace Ethanol.MalwareSonar.MalwareReport
{
    using System.Text.Json.Serialization;

    /// <summary>
    /// Represents a report detailing information about malware.
    /// </summary>
    public partial class Report
    {
        /// <summary>
        /// Gets or sets the version of the malware report.
        /// </summary>
        [JsonPropertyName("version")]
        public string? Version { get; set; }

        /// <summary>
        /// Gets or sets information about the malware sample used in the report.
        /// </summary>
        [JsonPropertyName("sample")]
        public Sample? Sample { get; set; }

        /// <summary>
        /// Gets or sets a collection of tasks related to the malware report.
        /// </summary>
        [JsonPropertyName("tasks")]
        public AnalysisTask[]? Tasks { get; set; }

        /// <summary>
        /// Gets or sets the analysis information pertaining to the malware.
        /// </summary>
        [JsonPropertyName("analysis")]
        public Analysis? Analysis { get; set; }

        /// <summary>
        /// Gets or sets a collection of target information that the malware might potentially affect.
        /// </summary>
        [JsonPropertyName("targets")]
        public Target[]? Targets { get; set; }

        /// <summary>
        /// Gets or sets a collection of signatures that can be used to detect the malware.
        /// </summary>
        [JsonPropertyName("signatures")]
        public Signature[]? Signatures { get; set; }

        /// <summary>
        /// Gets or sets a collection of extracted information from the malware.
        /// </summary>
        [JsonPropertyName("extracted")]
        public Extracted[]? Extracted { get; set; }
    }
}
