﻿namespace Ethanol.MalwareSonar.MalwareReport
{
    using System.Text.Json.Serialization;

    /// <summary>
    /// Represents a Credential object.
    /// </summary>
    public partial class Credential
    {
        /// <summary>
        /// Gets or sets the protocol for the credential.
        /// </summary>
        [JsonPropertyName("protocol")]
        public string? Protocol { get; set; }

        /// <summary>
        /// Gets or sets the host for the credential.
        /// </summary>
        [JsonPropertyName("host")]
        public string? Host { get; set; }

        /// <summary>
        /// Gets or sets the port for the credential.
        /// </summary>
        [JsonPropertyName("port")]
        public long Port { get; set; }

        /// <summary>
        /// Gets or sets the username for the credential.
        /// </summary>
        [JsonPropertyName("username")]
        public string? Username { get; set; }

        /// <summary>
        /// Gets or sets the password for the credential.
        /// </summary>
        [JsonPropertyName("password")]
        public string? Password { get; set; }

        /// <summary>
        /// Gets or sets the email to which the credential is associated.
        /// </summary>
        [JsonPropertyName("email_to")]
        public string? EmailTo { get; set; }
    }
}
