# Experiments with CTU provided datasets

The datasets are available at: https://www.stratosphereips.org/datasets-ctu13

The CTU-13 is a dataset of botnet traffic captured in 2011. The dataset consists of thirteen scenarios of different botnet samples. 
For each scenario the capture file with malware communication is provided.

## Dataset preparation

The capture files are processed by flowmon exporter to obtain a CSV files fiwth IPFIX flows as follows:

```
 sudo flowmonexp5 -I pcap-replay:file=botnet-capture-20110810-neris.pcap,speed=1 -P nbar2 -P tls:fields=MAIN#JA3#CLIENT#CERT -P dns -P http -E csv > botnet.csv
```
where

* `-I pcap-replay:file=FILE` - specifies the input capture file
* `-P FILTER` - defines processing FILTER, which is used to enrich IPFIX records
* `-E csv` - specifies that CSV output should be produced


```
sudo flowmonexp5 -I null -P nbar2 -P tls:fields=MAIN#JA3 -P dns -P http -E json
```

We consider the following filters:

```
plugin-type:        PROCESS
plugin-name:        tls
plugin-flags:       NEED_PACKET
plugin-addon-size:  8
plugin-description: tls protocol parser
  Parameters:
  fields=list                   (delimited by #, possible values MAIN, CERT, CLIENT, JA3)
```

```
plugin-type:        PROCESS
plugin-name:        nbar2
plugin-flags:       NEED_PACKET
plugin-addon-size:  16
plugin-description: l7 identificator using libprotoident
```

```
plugin-type:        PROCESS
plugin-name:        http
plugin-flags:       NEED_PACKET
plugin-addon-size:  8
plugin-description: simple http parser
  Parameters
   split-flows=0|1     create multiple flows for multiple requests in one connection   allow-invalid=0|1   don't drop requests with HTTP method first
```

```
plugin-type:        PROCESS
plugin-name:        dns
plugin-flags:       NEED_PACKET
plugin-addon-size:  15
plugin-description: DNS plugin for parsing basic DNS header, question and answer information.
```

```
plugin-type:        PROCESS
plugin-name:        smb
plugin-flags:       NEED_PACKET
plugin-addon-size:  8
plugin-description: smb parser
  Parameters
   port=<0,65535>     parse only packets on chosen port, default = 445 (zero means Don't filter, parse all ports)   treetable-size=<unsigned int>   filetable-size=<unsigned int>   messagetable-size=<unsigned int>   messagetable2-size=<unsigned int>   datatable-size=<unsigned int>
```