# Flowmon Smart ADS tags

The datasource is generated by various modules that identify properties for (mostly) endpoints.

The datasource is represented by a CSV of the following format:

* type of identifier (IP, MAC addresses, etc)
* identifier value
* type of value 
* valid from 
* valid to
* confidence level (0-1)
* source module
* value

## OS Detection
```
ip,147.229.176.80,os_by_tcpip,2021-11-09T03:35:58.783846,2021-11-09T03:35:58.783846,1.0,os_by_tcpip@collector-enta,"Windows"
```
stands for:

```yaml
os-by-tcpip:
  key: 
    ip: 147.229.176.80     
  valid-from: 2021-11-09T03:35:58.783846
  valid-to: 2021-11-09T03:35:58.783846
  source: os_by_tcpip@collector-enta
  confidence: 1.0
  value: Windows 
```

* type of identifier: `ip` 
* identifier: `147.229.176.80`
* type of value: `os_by_tcpip` - represents OS name as identified from TCP/IP fingerprinting
* valid from: `2021-11-09T03:35:58.783846`
* valid to: `2021-11-09T03:35:58.783846`
* confidence level: `1.0`
* source module: `os_by_tcpip@collector-enta`
* value: `"Windows"`

## User Agent
```
ip,147.229.13.102,http_useragent,2021-11-09T03:34:06.975,2021-11-09T03:49:08.050,1.0,http_useragent@colnem,"Debian APT-HTTP/1.3 (1.2.32ubuntu0.2)"
ip,147.229.13.167,operating_system_ua,2021-11-10T02:10:29.676,2021-11-10T02:25:30.831,1.0,http_useragent@colnem,Debian
ip,147.229.13.167,hardware_type_ua,2021-11-10T02:10:29.676,2021-11-10T02:25:30.831,1.0,http_useragent@colnem,computer
ip,147.32.232.150,software_name_ua,2021-11-10T02:10:29.676,2021-11-10T02:25:30.831,1.0,http_useragent@colnem,Flock
ip,147.32.232.150,software_type_ua,2021-11-10T02:10:29.676,2021-11-10T02:25:30.831,1.0,http_useragent@colnem,web-browser
```

```yaml
http-useragent: 
  key:   
    srcIp: 147.229.13.102
  valid-from: 2021-11-09T03:34:06.975
  valid-to: 2021-11-09T03:49:08.050
  source: http_useragent@colnem
  confidence: 1.0
  value: Debian APT-HTTP/1.3 (1.2.32ubuntu0.2) 
```

## Dependency Mapping
```
ip_dependency,8.8.4.4:53-192.168.3.5,dep,2021-11-09T03:34:33.229,2021-11-09T03:49:31.259,1.0,dependency_mapping@netmonlab,{"num_packets": 33}
```

## Flow Classifier
```
ip,192.168.88.1,out_flow_tags,2021-11-09T03:46:04,2021-11-09T03:46:04,1.0,flow_classifier@netmonlab,"NETWORKSERVICE:ntp"
ip,192.168.3.5,in_flow_tags,2021-11-10T02:27:58,2021-11-10T02:29:30,1.0,flow_classifier@netmonlab,"NETWORKSERVICE:ntp"
```

```yaml
out-flow-tags: 
  key: 
    srcIp: 192.168.88.1
  valid-from: 2021-11-09T03:46:04
  valid-to: 2021-11-09T03:46:04
  source: flow_classifier@netmonlab
  confidence: 1.0
  value: "NETWORKSERVICE:ntp 
```

## Activity
```
ip,192.168.3.107,activity_flows,2021-11-09T03:30:00,2021-11-09T03:40:00,1.0,ip_activity_new@netmonlab,4.5
ip,192.168.3.107,activity_packets,2021-11-09T03:30:00,2021-11-09T03:40:00,1.0,ip_activity_new@netmonlab,90.9192
```

## Services
```
ip,147.32.232.77,open_ports,2021-11-09T03:38:11.576,2021-11-09T03:53:25.893,1.0,service_labels@colnem,[80, 443, 2222, 3215]

ip,147.229.8.12,tags_by_services,2021-11-09T03:38:26.286,2021-11-09T03:53:29.456,1.0,service_labels@colnem,["DNS Server:53", "Printer:515", "MSA Agent:587", "Mail Server:993", "Mail server:25", "Mail Server:143", "Mail Server:465"]
```
```yaml
tags_by_services: 
  key: 
    ip: 147.229.8.12
  valid-from: 2021-11-09T03:38:26.286
  valid-to: 2021-11-09T03:53:29.456
  source: service_labels@colnem
  confidence: 1.0
  value: ["DNS Server:53", "Printer:515", "MSA Agent:587", "Mail Server:993", "Mail server:25", "Mail Server:143", "Mail Server:465"] 
```


## IP Mac
```
ip_mac,00:4e:01:ad:16:f4-192.168.3.5,a,2021-11-09T04:24:30.257,2021-11-09T04:33:00.429,1.0,ip_mac@netmonlab,true

```
## SDP 
```
mac,78:24:af:33:28:7b,sdp_label,2021-11-10T02:18:18,2021-11-10T02:27:33,1.0,sdp@netmonlab,{"name": "hostname"
mac,78:24:af:33:28:7b,dnssd_query,2021-11-10T02:18:18,2021-11-10T02:27:33,1.0,sdp@netmonlab,_dosvc._tcp.local
mac,78:24:af:33:28:7b,nbns_name,2021-11-10T02:18:18,2021-11-10T02:27:33,1.0,sdp@netmonlab,{"name": ""

```

## JA3Cury

```
ip,192.168.88.245,tls_os_family,2021-11-09T07:20:12,2021-11-09T07:30:35,0.54,ja3cury@netmonlab,["Mac OS X"]
ip,192.168.88.245,tls_os_name,2021-11-09T07:20:12,2021-11-09T07:30:35,0.31,ja3cury@netmonlab,["Mac OS X"
ip,192.168.88.245,tls_os_version,2021-11-09T07:20:12,2021-11-09T07:30:35,0.26,ja3cury@netmonlab,["Mac OS X"
ip,192.168.88.245,tls_categories,2021-11-09T07:20:12,2021-11-09T07:30:35,1.0,ja3cury@netmonlab,browser
ip,192.168.88.245,tls_processes,2021-11-09T07:20:12,2021-11-09T07:30:35,1.0,ja3cury@netmonlab,chrome
```
