# The configuration of the extension

## Network Boundary Shield (NBS)

NBS is active independently on the levels defined below. If necessary, you can whitelist websites for which the NBS should be turned off. Generally, you want NBS to be active, however, some pages can be broken, because they require interaction between public Internet and local network, for example, some Intranet information systems might be broken by the NBS.

## Levels controlling JS-object wrapping

### Level 0
* *All functionality is disabled OFF*

### Level 1

* **Manipulate the time precision provided by Date and performance: --** *ON*
    * Round time to: *hundredths of a second (1.230 -- Date, 1230 -- performance)*
* **Protect against canvas fingerprinting --** *OFF*
* **Spoof hardware information to the most popular HW --** *ON*
    * JS navigator.deviceMemory: *4* (not applied if the browser does not support the property, e.g.
			Firefox)
    * JS navigator.hardwareConcurrency: *2*
* **Filter XMLHttpRequest requests --** *OFF*
* **Protect against ArrayBuffer exploitation --** *OFF*
* **Protect against SharedArrayBuffer exploitation --** *OFF*
* **Protect against WebWorker exploitation --** *OFF*
* **Disable Battery status API --** *ON*

### Level 2
* **Manipulate the time precision provided by Date and performance --** *ON*
    * Round time to: *tenths of a second (1.200 -- Date, 1200 -- performance)*
* **Protect against canvas fingerprinting: --** *ON*
    * Reading from canvas returns white image.
* **Spoof hardware information to the most popular HW --** *ON*
    * JS navigator.deviceMemory: *4* (not applied if the browser does not support the property)
    * JS navigator.hardwareConcurrency: *2*
* **Filter XMLHttpRequest requests --** *OFF*
* **Protect against ArrayBuffer exploitation --** *OFF*
* **Protect against SharedArrayBuffer exploitation --** *OFF*
* **Protect against WebWorker exploitation --** *OFF*
* **Disable Battery status API --** *ON*

### Level 3
* **Manipulate the time precision provided by Date and performance --** *ON*
    * Round time to: *full seconds (1.000 -- Date, 1000 -- performance)*
		* *Randomize time*
* **Protect against canvas fingerprinting: --** *ON*
    * Reading from canvas returns white image.
* **Spoof hardware information to the most popular HW --** *ON*
    * JS navigator.deviceMemory: *4* (not applied if the browser does not support the property)
    * JS navigator.hardwareConcurrency: *2*
* **Filter XMLHttpRequest requests: --** *confirm requests but do not block*
* **Protect against ArrayBuffer exploitation --** *ON*
    * *Use random mapping of array indexing to memory*
* **Protect against SharedArrayBuffer exploitation --** *ON*
    * *Block SharedArrayBuffer* -- SharedArrayBuffer provided by the browser is not available to page scripts at all.
* **Protect against WebWorker exploitation --** *ON*
    * *Remove real parallelism* -- Use Worker polyfill instead of the native Worker.
* **Disable Battery status API --** *ON*

