#!/usr/bin/env python3
# -*- coding: utf-8 -*-

""" Test package for retrieving addtional information for ORouters """
# Copyright (C) 2018 Libor Polčák
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import unittest
import subprocess

import dns
import parametrizable_tc as ptc

class test_additional_info(unittest.TestCase, metaclass=ptc.parametrizable_tc_meta):

    @ptc.parametrizable_test([
                ("pcpolcak", ["147.229.13.162", "pcpolcak.fit.vutbr.cz"]),
                ("merlin6", ["2001:67c:1220:8b0::93e5:b013", "merlin6.fit.vutbr.cz"]),
                ("sirius", ["193.165.45.58", "sirius.polcakovi.cz"]),
                ("failed", ["0.1.2.3", None]),
            ])
    def test_dns(self, ip_addr, expected):
        self.assertEqual(dns.ip_addr_to_domain(ip_addr), expected,
                subprocess.run(["host", ip_addr], stdout=subprocess.PIPE).stdout)

def suite():
        test = unittest.makeSuite(test_additional_info, "test")
        return unittest.TestSuite(tuple(test))

def test(verbosity=2, failfast=False):
        runner = unittest.TextTestRunner(verbosity=verbosity,failfast=failfast)
        runner.run(suite())

if __name__ == '__main__':
    test(verbosity=2)
