# dns.py: Functions working with DNS
# Copyright (C) 2018 Libor Polčák <ipolcak@fit.vutbr.cz>
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

import socket

def ip_addr_to_domain(ip_addr):
    """ Converts IPv4/IPv6 address to its primary PTR name.

    Note that in case of failed resolution, it returns None.
    """
    try:
        return socket.gethostbyaddr(ip_addr)[0]
    except socket.herror:
        return None
