/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.query.Dataset;

public class SimpleDataset
implements Dataset,
Serializable {
    private static final long serialVersionUID = 7841576172053060417L;
    private Set<IRI> defaultRemoveGraphs = new LinkedHashSet<IRI>();
    private IRI defaultInsertGraph;
    private Set<IRI> defaultGraphs = new LinkedHashSet<IRI>();
    private Set<IRI> namedGraphs = new LinkedHashSet<IRI>();

    @Override
    public Set<IRI> getDefaultRemoveGraphs() {
        return Collections.unmodifiableSet(this.defaultRemoveGraphs);
    }

    public void addDefaultRemoveGraph(IRI graphURI) {
        this.defaultRemoveGraphs.add(graphURI);
    }

    public boolean removeDefaultRemoveGraph(IRI graphURI) {
        return this.defaultRemoveGraphs.remove(graphURI);
    }

    @Override
    public IRI getDefaultInsertGraph() {
        return this.defaultInsertGraph;
    }

    public void setDefaultInsertGraph(IRI defaultInsertGraph) {
        this.defaultInsertGraph = defaultInsertGraph;
    }

    @Override
    public Set<IRI> getDefaultGraphs() {
        return Collections.unmodifiableSet(this.defaultGraphs);
    }

    public void addDefaultGraph(IRI graphURI) {
        this.defaultGraphs.add(graphURI);
    }

    public boolean removeDefaultGraph(IRI graphURI) {
        return this.defaultGraphs.remove(graphURI);
    }

    @Override
    public Set<IRI> getNamedGraphs() {
        return Collections.unmodifiableSet(this.namedGraphs);
    }

    public void addNamedGraph(IRI graphURI) {
        this.namedGraphs.add(graphURI);
    }

    public boolean removeNamedGraph(IRI graphURI) {
        return this.namedGraphs.remove(graphURI);
    }

    public void clear() {
        this.defaultRemoveGraphs.clear();
        this.defaultInsertGraph = null;
        this.defaultGraphs.clear();
        this.namedGraphs.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRI uri : this.getDefaultRemoveGraphs()) {
            sb.append("DELETE FROM ");
            this.appendURI(sb, uri);
        }
        if (this.getDefaultInsertGraph() != null) {
            sb.append("INSERT INTO ");
            this.appendURI(sb, this.getDefaultInsertGraph());
        }
        for (IRI uri : this.getDefaultGraphs()) {
            sb.append("FROM ");
            this.appendURI(sb, uri);
        }
        for (IRI uri : this.getNamedGraphs()) {
            sb.append("FROM NAMED ");
            this.appendURI(sb, uri);
        }
        if (this.getDefaultGraphs().isEmpty() && this.getNamedGraphs().isEmpty()) {
            sb.append("## empty dataset ##");
        }
        return sb.toString();
    }

    private void appendURI(StringBuilder sb, IRI uri) {
        String str = uri.toString();
        if (str.length() > 50) {
            sb.append("<").append(str, 0, 19).append("..");
            sb.append(str, str.length() - 29, str.length()).append(">\n");
        } else {
            sb.append("<").append(uri).append(">\n");
        }
    }
}

