/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.http.protocol.transaction.operations;

import java.io.Serializable;
import org.eclipse.rdf4j.http.protocol.transaction.operations.TransactionOperation;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;

public class SPARQLUpdateOperation
implements TransactionOperation,
Serializable {
    private static final long serialVersionUID = 4432275498318918582L;
    private String updateString;
    private String baseURI;
    private boolean includeInferred;
    private Dataset dataset;
    private Binding[] bindings;

    public SPARQLUpdateOperation() {
    }

    public SPARQLUpdateOperation(String updateString, String baseURI, boolean includeInferred, Dataset dataset, Binding ... bindings) {
        this.setUpdateString(updateString);
        this.setBaseURI(baseURI);
        this.setIncludeInferred(includeInferred);
        this.setDataset(dataset);
        this.setBindings(bindings);
    }

    @Override
    public void execute(RepositoryConnection con) throws RepositoryException {
        try {
            Update preparedUpdate = con.prepareUpdate(QueryLanguage.SPARQL, this.getUpdateString(), this.getBaseURI());
            preparedUpdate.setIncludeInferred(this.isIncludeInferred());
            preparedUpdate.setDataset(this.getDataset());
            if (this.getBindings() != null) {
                for (Binding binding : this.getBindings()) {
                    preparedUpdate.setBinding(binding.getName(), binding.getValue());
                }
            }
            preparedUpdate.execute();
        }
        catch (MalformedQueryException e) {
            throw new RepositoryException(e);
        }
        catch (UpdateExecutionException e) {
            throw new RepositoryException(e);
        }
    }

    public String getUpdateString() {
        return this.updateString;
    }

    public void setUpdateString(String updateString) {
        this.updateString = updateString;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public boolean isIncludeInferred() {
        return this.includeInferred;
    }

    public void setIncludeInferred(boolean includeInferred) {
        this.includeInferred = includeInferred;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    public Binding[] getBindings() {
        return this.bindings;
    }

    public void setBindings(Binding[] bindings) {
        this.bindings = bindings;
    }
}

