/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.impl;

import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.hbase.metrics.Counter;
import org.apache.hadoop.hbase.metrics.Gauge;
import org.apache.hadoop.hbase.metrics.Histogram;
import org.apache.hadoop.hbase.metrics.Meter;
import org.apache.hadoop.hbase.metrics.Metric;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.metrics.MetricRegistryInfo;
import org.apache.hadoop.hbase.metrics.Timer;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HBaseMetrics2HadoopMetricsAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(HBaseMetrics2HadoopMetricsAdapter.class);
    private static final String EMPTY_STRING = "";

    public void snapshotAllMetrics(MetricRegistry metricRegistry, MetricsCollector collector) {
        MetricRegistryInfo info = metricRegistry.getMetricRegistryInfo();
        MetricsRecordBuilder builder = collector.addRecord(Interns.info((String)info.getMetricsName(), (String)info.getMetricsDescription()));
        builder.setContext(info.getMetricsContext());
        this.snapshotAllMetrics(metricRegistry, builder);
    }

    public void snapshotAllMetrics(MetricRegistry metricRegistry, MetricsRecordBuilder builder) {
        Map<String, Metric> metrics = metricRegistry.getMetrics();
        for (Map.Entry<String, Metric> e : metrics.entrySet()) {
            String name = StringUtils.capitalize(e.getKey());
            Metric metric = e.getValue();
            if (metric instanceof Gauge) {
                this.addGauge(name, (Gauge)metric, builder);
                continue;
            }
            if (metric instanceof Counter) {
                this.addCounter(name, (Counter)metric, builder);
                continue;
            }
            if (metric instanceof Histogram) {
                this.addHistogram(name, (Histogram)metric, builder);
                continue;
            }
            if (metric instanceof Meter) {
                this.addMeter(name, (Meter)metric, builder);
                continue;
            }
            if (metric instanceof Timer) {
                this.addTimer(name, (Timer)metric, builder);
                continue;
            }
            LOG.info("Ignoring unknown Metric class " + metric.getClass().getName());
        }
    }

    private void addGauge(String name, Gauge<?> gauge, MetricsRecordBuilder builder) {
        MetricsInfo info = Interns.info((String)name, (String)EMPTY_STRING);
        Object o = gauge.getValue();
        if (o instanceof Integer) {
            builder.addGauge(info, ((Integer)o).intValue());
        } else if (o instanceof Long) {
            builder.addGauge(info, ((Long)o).longValue());
        } else if (o instanceof Float) {
            builder.addGauge(info, ((Float)o).floatValue());
        } else if (o instanceof Double) {
            builder.addGauge(info, ((Double)o).doubleValue());
        } else {
            LOG.warn("Ignoring Gauge (" + name + ") with unhandled type: " + o.getClass());
        }
    }

    private void addCounter(String name, Counter counter, MetricsRecordBuilder builder) {
        MetricsInfo info = Interns.info((String)name, (String)EMPTY_STRING);
        builder.addCounter(info, counter.getCount());
    }

    private void addHistogram(String name, Histogram histogram, MetricsRecordBuilder builder) {
        MutableHistogram.snapshot(name, EMPTY_STRING, histogram, builder, true);
    }

    private void addMeter(String name, Meter meter, MetricsRecordBuilder builder) {
        builder.addGauge(Interns.info((String)(name + "_count"), (String)EMPTY_STRING), meter.getCount());
        builder.addGauge(Interns.info((String)(name + "_mean_rate"), (String)EMPTY_STRING), meter.getMeanRate());
        builder.addGauge(Interns.info((String)(name + "_1min_rate"), (String)EMPTY_STRING), meter.getOneMinuteRate());
        builder.addGauge(Interns.info((String)(name + "_5min_rate"), (String)EMPTY_STRING), meter.getFiveMinuteRate());
        builder.addGauge(Interns.info((String)(name + "_15min_rate"), (String)EMPTY_STRING), meter.getFifteenMinuteRate());
    }

    private void addTimer(String name, Timer timer, MetricsRecordBuilder builder) {
        this.addMeter(name, timer.getMeter(), builder);
        this.addHistogram(name, timer.getHistogram(), builder);
    }
}

