/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.core;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public class ResourceFactory {
    private static final ValueFactory vf = SimpleValueFactory.getInstance();
    private static final String RESOURCE_PREFIX = "http://nesfit.github.io/resource/ta#";

    public static IRI createResourceIRI(String module, String type, String id) {
        return vf.createIRI(RESOURCE_PREFIX, module + "-" + type + "-" + id);
    }

    public static IRI createUrlIRI(String urlString) {
        try {
            String encUri = URLEncoder.encode(urlString, "UTF-8");
            return vf.createIRI(RESOURCE_PREFIX, "url-" + encUri);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static IRI createFileIRI(String taskId, String fullPath) {
        try {
            String encUri = URLEncoder.encode(fullPath, "UTF-8");
            return vf.createIRI(RESOURCE_PREFIX, "file-" + taskId + "-" + encUri);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }
}

