/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadTool {
    private static Logger log = LoggerFactory.getLogger(DownloadTool.class);
    private static final String KEY_REPO_URL = "repo.url";
    private static final String KEY_DOWNLOAD_START_DATE = "download.startDate";
    private static final String KEY_DOWNLOAD_END_DATE = "download.endDate";
    private static final String KEY_DOWNLOAD_LIMIT = "download.limit";
    private static final String CONFIG_FILE = "config.properties";
    private static final String DEFAULT_START_DATE = "01/08/2017";
    private Properties configFile = this.loadConfigFile();
    private String repositoryUrl = "http://localhost:8080/rdf4j-server/repositories/ta";
    private Date startDate;
    private Date endDate;
    private int limit = 1000;

    public DownloadTool() {
        this.loadConfigValues();
        log.info("Using repository URL: {}", (Object)this.repositoryUrl);
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public int getLimit() {
        return this.limit;
    }

    protected void loadConfigValues() {
        this.repositoryUrl = this.getConfig(KEY_REPO_URL, this.repositoryUrl);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            this.startDate = sdf.parse(DEFAULT_START_DATE);
            this.startDate = this.getConfig(KEY_DOWNLOAD_START_DATE, this.startDate, sdf);
        }
        catch (ParseException e) {
            log.error("Incorrect config value of {}: {}", (Object)KEY_DOWNLOAD_START_DATE, (Object)e.getMessage());
        }
        try {
            this.endDate = new Date();
            this.endDate = this.getConfig(KEY_DOWNLOAD_END_DATE, this.endDate, sdf);
        }
        catch (ParseException e) {
            log.error("Incorrect config value of {}: {}", (Object)KEY_DOWNLOAD_END_DATE, (Object)e.getMessage());
        }
        try {
            this.limit = this.getConfig(KEY_DOWNLOAD_LIMIT, this.limit);
        }
        catch (NumberFormatException e) {
            log.error("Incorrect config value of {}: {}", (Object)KEY_DOWNLOAD_LIMIT, (Object)e.getMessage());
        }
    }

    protected String getConfig(String key, String defaultValue) {
        String ret = System.getProperty(key);
        if (ret == null && this.configFile != null) {
            ret = this.configFile.getProperty(key);
        }
        return ret == null ? defaultValue : ret;
    }

    protected int getConfig(String key, int defaultValue) throws NumberFormatException {
        String ret = System.getProperty(key);
        if (ret == null && this.configFile != null) {
            ret = this.configFile.getProperty(key);
        }
        return ret == null ? defaultValue : Integer.parseInt(ret);
    }

    protected Date getConfig(String key, Date defaultValue, DateFormat dateFormat) throws ParseException {
        String ret = System.getProperty(key);
        if (ret == null && this.configFile != null) {
            ret = this.configFile.getProperty(key);
        }
        return ret == null ? defaultValue : dateFormat.parse(ret);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Properties loadConfigFile() {
        try (FileInputStream input = new FileInputStream(CONFIG_FILE);){
            Properties prop = new Properties();
            prop.load(input);
            Properties properties = prop;
            return properties;
        }
        catch (IOException ex) {
            return null;
        }
    }
}

