/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.spark;

import cz.vutbr.fit.ta.core.ResourceFactory;
import cz.vutbr.fit.ta.halyard.RDFConnectorHalyard;
import cz.vutbr.fit.ta.ontology.Timeline;
import cz.vutbr.fit.ta.splaso.PlasoEntry;
import cz.vutbr.fit.ta.splaso.PlasoParser;
import cz.vutbr.fit.ta.splaso.PlasoTextParser;
import cz.vutbr.fit.ta.splaso.SparkPlasoSource;
import io.github.radkovo.rdf4j.builder.TargetModel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;

public class Cli {
    public static void main(String[] args) {
        try {
            RDFConnectorHalyard rdfcon;
            InputStream is;
            PosixParser parser = new PosixParser();
            CommandLine cli = parser.parse(Cli.getCliOpts(), args);
            if (cli.hasOption('h')) {
                Cli.printHelp();
                return;
            }
            String[] cliArgs = cli.getArgs();
            if (cliArgs.length == 0) {
                is = System.in;
            } else if (cliArgs.length == 1) {
                is = new FileInputStream(cliArgs[0]);
            } else {
                throw new ParseException("Too many arguments");
            }
            PlasoTextParser p = new PlasoTextParser();
            List<PlasoEntry> entries = ((PlasoParser)p).parseInputStream(is);
            is.close();
            System.out.println("Read " + entries.size() + " entries");
            SparkPlasoSource src = new SparkPlasoSource("plasotest", entries);
            Timeline timeline = src.getTimeline();
            TargetModel target = new TargetModel(new LinkedHashModel());
            target.add(timeline);
            System.out.println("Model created, " + target.getModel().size() + " triples");
            System.out.println("Saving start at " + new Date());
            String tableName = cli.getOptionValue('t');
            System.out.println("Using table " + tableName);
            if (cli.hasOption('c')) {
                String configPath = cli.getOptionValue('c');
                rdfcon = new RDFConnectorHalyard(configPath, tableName);
            } else if (cli.hasOption('q')) {
                String quora = cli.getOptionValue('q');
                int port = Integer.valueOf(cli.getOptionValue('p'));
                rdfcon = new RDFConnectorHalyard(quora, port, tableName);
            } else {
                rdfcon = new RDFConnectorHalyard(tableName);
            }
            rdfcon.add(target.getModel(), Cli.getContext());
            rdfcon.close();
            System.out.println("Saving finished at " + new Date());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (MissingOptionException e) {
            Cli.printHelp("Missing option: " + e.getMessage());
        }
        catch (ParseException e) {
            Cli.printHelp(e.getMessage());
        }
    }

    protected static Resource getContext() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date today = Calendar.getInstance().getTime();
        String stamp = df.format(today);
        return ResourceFactory.createResourceIRI("plaso", "context", stamp);
    }

    private static void printHelp() {
        Cli.printHelp(null);
    }

    private static void printHelp(String error) {
        HelpFormatter hf = new HelpFormatter();
        PrintWriter w = new PrintWriter(System.out);
        if (error != null) {
            hf.printWrapped(w, 80, error);
            w.println();
        }
        hf.printWrapped(w, 80, 12, "usage: Main [options...] [<input-file>]");
        hf.printWrapped(w, 80, 42, "  <input-file>                  the input file to read from, stdin if omitted");
        hf.printOptions(w, 80, Cli.getCliOpts(), 2, 2);
        w.flush();
        w.close();
    }

    private static Options getCliOpts() {
        Options o = new Options();
        OptionBuilder.withLongOpt("table-name");
        OptionBuilder.withDescription("HBase table name to be used (required)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("table name");
        OptionBuilder.isRequired(true);
        o.addOption(OptionBuilder.create('t'));
        OptionBuilder.withLongOpt("quora");
        OptionBuilder.withDescription("zookeeper quora (e.g. server1,server2)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("quora list");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('q'));
        OptionBuilder.withLongOpt("port");
        OptionBuilder.withDescription("zookeeper port");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("port");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('p'));
        OptionBuilder.withLongOpt("config");
        OptionBuilder.withDescription("the hbase-site.xml config file to be used (replaces -p and -q)");
        OptionBuilder.hasArgs(1);
        OptionBuilder.withArgName("config");
        OptionBuilder.isRequired(false);
        o.addOption(OptionBuilder.create('c'));
        OptionBuilder.withLongOpt("help");
        OptionBuilder.withDescription("print this help");
        OptionBuilder.isRequired(false);
        OptionBuilder.hasArg(false);
        o.addOption(OptionBuilder.create('h'));
        return o;
    }
}

