/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.quotas;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.quotas.QuotaExceededException;
import org.apache.yetus.audience.InterfaceAudience;

@Deprecated
@InterfaceAudience.Public
public class ThrottlingException
extends QuotaExceededException {
    private static final long serialVersionUID = 1406576492085155743L;
    private static final String[] MSG_TYPE = new String[]{"number of requests exceeded", "request size limit exceeded", "number of read requests exceeded", "number of write requests exceeded", "write size limit exceeded", "read size limit exceeded"};
    private static final String MSG_WAIT = " - wait ";
    private long waitInterval;
    private Type type;

    public ThrottlingException(String msg) {
        super(msg);
        for (int i = 0; i < MSG_TYPE.length; ++i) {
            int index = msg.indexOf(MSG_TYPE[i]);
            if (index < 0) continue;
            String waitTimeStr = msg.substring(index + MSG_TYPE[i].length() + MSG_WAIT.length());
            this.type = Type.values()[i];
            this.waitInterval = ThrottlingException.timeFromString(waitTimeStr);
            break;
        }
    }

    public ThrottlingException(Type type, long waitInterval, String msg) {
        super(msg);
        this.waitInterval = waitInterval;
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public long getWaitInterval() {
        return this.waitInterval;
    }

    public static void throwNumRequestsExceeded(long waitInterval) throws ThrottlingException {
        ThrottlingException.throwThrottlingException(Type.NumRequestsExceeded, waitInterval);
    }

    public static void throwRequestSizeExceeded(long waitInterval) throws ThrottlingException {
        ThrottlingException.throwThrottlingException(Type.RequestSizeExceeded, waitInterval);
    }

    public static void throwNumReadRequestsExceeded(long waitInterval) throws ThrottlingException {
        ThrottlingException.throwThrottlingException(Type.NumReadRequestsExceeded, waitInterval);
    }

    public static void throwNumWriteRequestsExceeded(long waitInterval) throws ThrottlingException {
        ThrottlingException.throwThrottlingException(Type.NumWriteRequestsExceeded, waitInterval);
    }

    public static void throwWriteSizeExceeded(long waitInterval) throws ThrottlingException {
        ThrottlingException.throwThrottlingException(Type.WriteSizeExceeded, waitInterval);
    }

    public static void throwReadSizeExceeded(long waitInterval) throws ThrottlingException {
        ThrottlingException.throwThrottlingException(Type.ReadSizeExceeded, waitInterval);
    }

    private static void throwThrottlingException(Type type, long waitInterval) throws ThrottlingException {
        String msg = MSG_TYPE[type.ordinal()] + MSG_WAIT + ThrottlingException.formatTime(waitInterval);
        throw new ThrottlingException(type, waitInterval, msg);
    }

    public static String formatTime(long timeDiff) {
        StringBuilder buf = new StringBuilder();
        long hours = timeDiff / 3600000L;
        long rem = timeDiff % 3600000L;
        long minutes = rem / 60000L;
        float seconds = (float)(rem %= 60000L) / 1000.0f;
        if (hours != 0L) {
            buf.append(hours);
            buf.append("hrs, ");
        }
        if (minutes != 0L) {
            buf.append(minutes);
            buf.append("mins, ");
        }
        buf.append(String.format("%.2fsec", Float.valueOf(seconds)));
        return buf.toString();
    }

    private static long timeFromString(String timeDiff) {
        Pattern[] patterns = new Pattern[]{Pattern.compile("^(\\d+\\.\\d\\d)sec"), Pattern.compile("^(\\d+)mins, (\\d+\\.\\d\\d)sec"), Pattern.compile("^(\\d+)hrs, (\\d+)mins, (\\d+\\.\\d\\d)sec")};
        for (int i = 0; i < patterns.length; ++i) {
            Matcher m = patterns[i].matcher(timeDiff);
            if (!m.find()) continue;
            long time = Math.round(Float.parseFloat(m.group(1 + i)) * 1000.0f);
            if (i > 0) {
                time += Long.parseLong(m.group(i)) * 60000L;
            }
            if (i > 1) {
                time += Long.parseLong(m.group(i - 1)) * 3600000L;
            }
            return time;
        }
        return -1L;
    }

    @InterfaceAudience.Public
    public static enum Type {
        NumRequestsExceeded,
        RequestSizeExceeded,
        NumReadRequestsExceeded,
        NumWriteRequestsExceeded,
        WriteSizeExceeded,
        ReadSizeExceeded;

    }
}

