/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.ontology;

import cz.vutbr.fit.ta.ontology.Object;
import cz.vutbr.fit.ta.ontology.TAFactory;
import cz.vutbr.fit.ta.ontology.Timeline;
import cz.vutbr.fit.ta.ontology.vocabulary.TA;
import io.github.radkovo.rdf4j.builder.EntityFactory;
import io.github.radkovo.rdf4j.builder.RDFEntity;
import io.github.radkovo.rdf4j.builder.TargetModel;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;

public class Event
extends RDFEntity {
    public static final IRI CLASS_IRI = vf.createIRI("http://nesfit.github.io/ontology/ta.owl#Event");
    private Timeline sourceTimeline;
    private Set<Object> refersTo = new HashSet<Object>();
    private Date timestamp;

    public Event(IRI iri) {
        super(iri);
    }

    @Override
    public IRI getClassIRI() {
        return CLASS_IRI;
    }

    public Timeline getSourceTimeline() {
        return this.sourceTimeline;
    }

    public void setSourceTimeline(Timeline sourceTimeline) {
        this.sourceTimeline = sourceTimeline;
    }

    public Set<Object> getRefersTo() {
        return this.refersTo;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(Date timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public void addToModel(TargetModel target) {
        super.addToModel(target);
        this.addObject(target, TA.sourceTimeline, this.sourceTimeline);
        this.addCollection(target, TA.refersTo, this.refersTo);
        this.addValue(target, TA.timestamp, this.timestamp);
    }

    @Override
    public void loadFromModel(Model model, EntityFactory efactory) {
        super.loadFromModel(model, efactory);
        if (!(efactory instanceof TAFactory)) {
            throw new IllegalArgumentException("factory must be instance of TAFactory");
        }
        TAFactory factory = (TAFactory)efactory;
        Model m = model.filter((Resource)this.getIRI(), null, null, new Resource[0]);
        Set<IRI> sourceTimelineIRIs = this.getObjectIRIs(m, TA.sourceTimeline);
        if (!sourceTimelineIRIs.isEmpty()) {
            IRI iri = sourceTimelineIRIs.iterator().next();
            this.sourceTimeline = factory.createTimeline(iri);
            this.sourceTimeline.loadFromModel(m, factory);
        } else {
            this.sourceTimeline = null;
        }
        Set<IRI> refersToIRIs = this.getObjectIRIs(m, TA.refersTo);
        this.refersTo = new HashSet<Object>();
        for (IRI iri : refersToIRIs) {
            Object item = factory.createObject(iri);
            item.loadFromModel(m, factory);
            this.refersTo.add(item);
        }
        this.timestamp = this.loadDateValue(m, TA.timestamp);
    }
}

