/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.core;

import cz.vutbr.fit.ta.core.RDFConnector;
import cz.vutbr.fit.ta.core.RDFConnectorBase;
import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.SPARQLRepository;

public class RDFConnectorRemote
extends RDFConnectorBase
implements RDFConnector {
    protected String endpointUrl;
    protected RepositoryConnection connection;
    protected Repository repo;
    protected ValueFactory vf;

    public RDFConnectorRemote(String endpoint) throws RepositoryException {
        this.endpointUrl = endpoint;
        this.connection = null;
        this.vf = SimpleValueFactory.getInstance();
        this.initRepository();
    }

    public RepositoryConnection getConnection() throws RepositoryException {
        if (this.connection == null) {
            this.connection = this.repo.getConnection();
        }
        return this.connection;
    }

    @Override
    public void close() throws RepositoryException {
        if (this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    protected void initRepository() throws RepositoryException {
        this.repo = new SPARQLRepository(this.endpointUrl);
        this.repo.initialize();
    }

    @Override
    public void add(Resource s, IRI p, Value o) throws IOException {
        Statement stmt = this.vf.createStatement(s, p, o);
        this.connection.add(stmt, new Resource[0]);
        this.connection.commit();
    }

    @Override
    public void add(Resource s, IRI p, Value o, Resource context) throws IOException {
        Statement stmt = this.vf.createStatement(s, p, o);
        this.connection.add(stmt, context);
        this.connection.commit();
    }

    @Override
    public void add(Model m) throws IOException {
        this.connection.begin();
        this.connection.add(m, new Resource[0]);
        this.connection.commit();
    }

    @Override
    public void add(Model m, Resource context) throws IOException {
        this.connection.begin();
        this.connection.add(m, context);
        this.connection.commit();
    }

    public void add(GraphQueryResult m, Resource context) {
        this.connection.begin();
        this.connection.add(m, context);
        this.connection.commit();
    }

    public void remove(GraphQueryResult statements) {
        try {
            this.connection.begin();
            this.connection.remove(statements, new Resource[0]);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public void remove(Model statements) {
        try {
            this.connection.begin();
            this.connection.remove(statements, new Resource[0]);
            this.connection.commit();
        }
        catch (RepositoryException e) {
            e.printStackTrace();
        }
    }

    public TupleQueryResult executeQuery(String queryString) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String qs = this.getPrefixString() + queryString;
        TupleQuery query = this.connection.prepareTupleQuery(QueryLanguage.SPARQL, qs);
        TupleQueryResult tqr = query.evaluate();
        return tqr;
    }

    public GraphQueryResult executeConstructQuery(String queryString) throws RepositoryException, MalformedQueryException, QueryEvaluationException {
        String qs = this.getPrefixString() + queryString;
        GraphQuery query = this.connection.prepareGraphQuery(QueryLanguage.SPARQL, qs);
        GraphQueryResult tqr = query.evaluate();
        return tqr;
    }
}

