/*
 * Decompiled with CFR 0.152.
 */
package tarzan.helpers.rdd;

import cz.vutbr.fit.ta.core.RDFConnector;
import cz.vutbr.fit.ta.core.ResourceFactory;
import cz.vutbr.fit.ta.halyard.RDFConnectorHalyard;
import cz.vutbr.fit.ta.ontology.Timeline;
import cz.vutbr.fit.ta.splaso.PlasoEntry;
import cz.vutbr.fit.ta.splaso.PlasoJsonParser;
import cz.vutbr.fit.ta.splaso.SparkPlasoSource;
import io.github.radkovo.rdf4j.builder.RDFEntity;
import io.github.radkovo.rdf4j.builder.TargetModel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.VoidFunction;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;

public class HalyardRDD {
    private static final String MODULE_NAME = "plaso";
    private static final String PROFILE_ID = "plasotest";
    private static final Charset JSON_ENCODING = StandardCharsets.US_ASCII;
    private static final PlasoJsonParser PLASO_PARSER = new PlasoJsonParser();

    public static long saveToHalyard(JavaRDD<Object> javaRDD, String tableName, String hbaseZookeeperQuorumOrConfigPath, Integer hbaseZookeeperClientPort) throws IOException {
        long startTime = System.nanoTime();
        javaRDD.map((Function & Serializable)jsonString -> PLASO_PARSER.parseSingleEntry((InputStream)new ByteArrayInputStream(((String)jsonString).getBytes(JSON_ENCODING)))).foreachPartition((VoidFunction & Serializable)plasoEntryIterator -> HalyardRDD.foreachPartitionFunction(plasoEntryIterator, tableName, hbaseZookeeperQuorumOrConfigPath, hbaseZookeeperClientPort));
        long estimatedTime = System.nanoTime() - startTime;
        return estimatedTime;
    }

    public static long saveToHalyard(JavaRDD<Object> javaRDD, String tableName, String configPath) throws IOException {
        return HalyardRDD.saveToHalyard(javaRDD, tableName, configPath, null);
    }

    public static long saveToHalyard(JavaRDD<Object> javaRDD, String tableName) throws IOException {
        return HalyardRDD.saveToHalyard(javaRDD, tableName, null, null);
    }

    protected static Resource getContext() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Date today = Calendar.getInstance().getTime();
        String stamp = df.format(today);
        return ResourceFactory.createResourceIRI((String)MODULE_NAME, (String)"context", (String)stamp);
    }

    protected static RDFConnector createRDFConnector(String tableName, String hbaseZookeeperQuorumOrConfigPath, Integer hbaseZookeeperClientPort) throws IOException {
        if (hbaseZookeeperQuorumOrConfigPath != null && hbaseZookeeperClientPort != null) {
            return new RDFConnectorHalyard(hbaseZookeeperQuorumOrConfigPath, hbaseZookeeperClientPort.intValue(), tableName);
        }
        if (hbaseZookeeperQuorumOrConfigPath != null) {
            return new RDFConnectorHalyard(hbaseZookeeperQuorumOrConfigPath, tableName);
        }
        return new RDFConnectorHalyard(tableName);
    }

    protected static void foreachPartitionFunction(Iterator<PlasoEntry> plasoEntryIterator, String tableName, String hbaseZookeeperQuorumOrConfigPath, Integer hbaseZookeeperClientPort) throws IOException {
        RDFConnector rdfConnector = HalyardRDD.createRDFConnector(tableName, hbaseZookeeperQuorumOrConfigPath, hbaseZookeeperClientPort);
        List plasoEntriesList = StreamSupport.stream(Spliterators.spliteratorUnknownSize(plasoEntryIterator, 16), false).collect(Collectors.toList());
        SparkPlasoSource sparkPlasoSource = new SparkPlasoSource(PROFILE_ID, plasoEntriesList);
        Timeline timeline = sparkPlasoSource.getTimeline();
        TargetModel targetModel = new TargetModel((Model)new LinkedHashModel());
        targetModel.add((RDFEntity)timeline);
        rdfConnector.add(targetModel.getModel(), HalyardRDD.getContext());
        rdfConnector.close();
    }
}

