/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.ta.halyard;

import com.msd.gin.halyard.common.HalyardTableUtils;
import cz.vutbr.fit.ta.core.RDFConnector;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Table;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public class RDFConnectorHalyard
implements RDFConnector {
    private static final String HBASE_CONFIGURATION_ZOOKEEPER_QUORUM = "hbase.zookeeper.quorum";
    private static final String HBASE_CONFIGURATION_ZOOKEEPER_CLIENTPORT = "hbase.zookeeper.property.clientPort";
    private static final int DEFAULT_SPLIT_BITS = 3;
    private String tableName;
    private Configuration hConf;
    private Connection hConn;
    private Table hTable;

    public RDFConnectorHalyard(String tableName) throws IOException {
        this.tableName = tableName;
        this.connectHbase();
    }

    public RDFConnectorHalyard(String hbaseZookeeperQuorum, int hbaseZookeeperClientPort, String tableName) throws IOException {
        this.tableName = tableName;
        this.connectHbase(hbaseZookeeperQuorum, hbaseZookeeperClientPort);
    }

    public RDFConnectorHalyard(String configPath, String tableName) throws IOException {
        this.tableName = tableName;
        this.connectHbase(configPath);
    }

    public String getTableName() {
        return this.tableName;
    }

    @Override
    public void add(Resource s, IRI p, Value o) throws IOException {
        this.add(s, p, o, null);
    }

    @Override
    public void add(Resource s, IRI p, Value o, Resource context) throws IOException {
        KeyValue[] kvs;
        for (KeyValue kv : kvs = HalyardTableUtils.toKeyValues(s, p, o, null, false, System.currentTimeMillis())) {
            this.hTable.put(new Put(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getTimestamp()).add(kv));
        }
    }

    @Override
    public void add(Model m) throws IOException {
        for (Statement st : m) {
            this.add(st.getSubject(), st.getPredicate(), st.getObject(), st.getContext());
        }
    }

    @Override
    public void add(Model m, Resource context) throws IOException {
        for (Statement st : m) {
            this.add(st.getSubject(), st.getPredicate(), st.getObject(), context);
        }
    }

    @Override
    public void close() throws IOException {
        this.hTable.close();
    }

    private void connectHbase() throws IOException {
        this.hConf = HBaseConfiguration.create();
        this.hConn = ConnectionFactory.createConnection(this.hConf);
        this.hTable = HalyardTableUtils.getTable(this.hConn, this.tableName, false, 3);
    }

    private void connectHbase(String hbaseZookeeperQuorum, int hbaseZookeeperClientPort) throws IOException {
        this.hConf = HBaseConfiguration.create();
        this.hConf.set(HBASE_CONFIGURATION_ZOOKEEPER_QUORUM, hbaseZookeeperQuorum);
        this.hConf.setInt(HBASE_CONFIGURATION_ZOOKEEPER_CLIENTPORT, hbaseZookeeperClientPort);
        this.hConn = ConnectionFactory.createConnection(this.hConf);
        this.hTable = HalyardTableUtils.getTable(this.hConn, this.tableName, false, 3);
    }

    private void connectHbase(String configFilePath) throws IOException {
        this.hConf = HBaseConfiguration.create();
        this.hConf.addResource(new Path(configFilePath));
        this.hConn = ConnectionFactory.createConnection(this.hConf);
        this.hTable = HalyardTableUtils.getTable(this.hConn, this.tableName, false, 3);
    }
}

