/*
 * Decompiled with CFR 0.152.
 */
package io.github.radkovo.rdf4j.builder;

import io.github.radkovo.rdf4j.builder.EntityFactory;
import io.github.radkovo.rdf4j.builder.TargetModel;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public abstract class RDFEntity {
    public static final ValueFactory vf = SimpleValueFactory.getInstance();
    private IRI iri;

    public RDFEntity(IRI iri) {
        this.iri = iri;
    }

    public IRI getIRI() {
        return this.iri;
    }

    public void addToModel(TargetModel target) {
        target.getModel().add((Resource)this.getIRI(), RDF.TYPE, (Value)this.getClassIRI(), new Resource[0]);
        if (this.getLabel() != null) {
            target.getModel().add((Resource)this.getIRI(), RDFS.LABEL, (Value)vf.createLiteral(this.getLabel()), new Resource[0]);
        }
    }

    public void loadFromModel(Model model, EntityFactory factory) {
    }

    public String getLabel() {
        return null;
    }

    public abstract IRI getClassIRI();

    protected void addValue(TargetModel target, IRI propertyIRI, String value) {
        if (value != null) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
        }
    }

    protected void addValue(TargetModel target, IRI propertyIRI, int value) {
        target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
    }

    protected void addValue(TargetModel target, IRI propertyIRI, float value) {
        target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
    }

    protected void addValue(TargetModel target, IRI propertyIRI, double value) {
        target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
    }

    protected void addValue(TargetModel target, IRI propertyIRI, Date value) {
        target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
    }

    protected void addValue(TargetModel target, IRI propertyIRI, URL value) {
        target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value.toString()), new Resource[0]);
    }

    protected void addArray(TargetModel target, IRI propertyIRI, String[] values) {
        for (String value : values) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
        }
    }

    protected void addArray(TargetModel target, IRI propertyIRI, int[] values) {
        for (int value : values) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
        }
    }

    protected void addArray(TargetModel target, IRI propertyIRI, float[] values) {
        for (float value : values) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
        }
    }

    protected void addArray(TargetModel target, IRI propertyIRI, double[] values) {
        for (double value : values) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
        }
    }

    protected void addArray(TargetModel target, IRI propertyIRI, Date[] values) {
        for (Date value : values) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value), new Resource[0]);
        }
    }

    protected void addArray(TargetModel target, IRI propertyIRI, URL[] values) {
        for (URL value : values) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)vf.createLiteral(value.toString(), XMLSchema.ANYURI), new Resource[0]);
        }
    }

    protected void addObject(TargetModel target, IRI propertyIRI, RDFEntity obj) {
        target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)obj.getIRI(), new Resource[0]);
        target.add(obj);
    }

    protected void addCollection(TargetModel target, IRI propertyIRI, Collection<? extends RDFEntity> col) {
        for (RDFEntity rDFEntity : col) {
            target.getModel().add((Resource)this.getIRI(), propertyIRI, (Value)rDFEntity.getIRI(), new Resource[0]);
            target.add(rDFEntity);
        }
    }

    protected String[] loadStringArray(Model m, IRI pred) {
        Model stm = m.filter(null, pred, null, new Resource[0]);
        String[] ret = new String[stm.size()];
        int i = 0;
        for (Statement st : stm) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                ret[i] = val.stringValue();
            }
            ++i;
        }
        return ret;
    }

    protected int[] loadIntArray(Model m, IRI pred) {
        Model stm = m.filter(null, pred, null, new Resource[0]);
        int[] ret = new int[stm.size()];
        int i = 0;
        for (Statement st : stm) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                ret[i] = ((Literal)val).intValue();
            }
            ++i;
        }
        return ret;
    }

    protected float[] loadFloatArray(Model m, IRI pred) {
        Model stm = m.filter(null, pred, null, new Resource[0]);
        float[] ret = new float[stm.size()];
        int i = 0;
        for (Statement st : stm) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                ret[i] = ((Literal)val).floatValue();
            }
            ++i;
        }
        return ret;
    }

    protected double[] loadDoubleArray(Model m, IRI pred) {
        Model stm = m.filter(null, pred, null, new Resource[0]);
        double[] ret = new double[stm.size()];
        int i = 0;
        for (Statement st : stm) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                ret[i] = ((Literal)val).doubleValue();
            }
            ++i;
        }
        return ret;
    }

    protected Date[] loadDateArray(Model m, IRI pred) {
        Model stm = m.filter(null, pred, null, new Resource[0]);
        Date[] ret = new Date[stm.size()];
        int i = 0;
        for (Statement st : stm) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                ret[i] = ((Literal)val).calendarValue().toGregorianCalendar().getTime();
            }
            ++i;
        }
        return ret;
    }

    protected URL[] loadURLArray(Model m, IRI pred) {
        Model stm = m.filter(null, pred, null, new Resource[0]);
        URL[] ret = new URL[stm.size()];
        int i = 0;
        for (Statement st : stm) {
            Value val = st.getObject();
            if (val instanceof Literal) {
                try {
                    ret[i] = new URL(((Literal)val).stringValue());
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            ++i;
        }
        return ret;
    }

    protected String loadStringValue(Model m, IRI pred) {
        String[] vals = this.loadStringArray(m, pred);
        return vals.length == 0 ? null : vals[0];
    }

    protected int loadIntValue(Model m, IRI pred) {
        int[] vals = this.loadIntArray(m, pred);
        return vals.length == 0 ? 0 : vals[0];
    }

    protected float loadFloatValue(Model m, IRI pred) {
        float[] vals = this.loadFloatArray(m, pred);
        return vals.length == 0 ? 0.0f : vals[0];
    }

    protected double loadDoubleValue(Model m, IRI pred) {
        double[] vals = this.loadDoubleArray(m, pred);
        return vals.length == 0 ? 0.0 : vals[0];
    }

    protected Date loadDateValue(Model m, IRI pred) {
        Date[] vals = this.loadDateArray(m, pred);
        return vals.length == 0 ? null : vals[0];
    }

    protected URL loadURLValue(Model m, IRI pred) {
        URL[] vals = this.loadURLArray(m, pred);
        return vals.length == 0 ? null : vals[0];
    }

    protected Set<IRI> getObjectIRIs(Model m, IRI predicate) {
        return Models.objectIRIs(m.filter(null, predicate, null, new Resource[0]));
    }
}

